/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import ic.doc.ltsa.lts.ltl.Proposition;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class LabelFactory {
    SortedSet allprops;
    FormulaFactory fac;
    String name;
    HashMap tr;
    BitSet[] ps;
    BitSet[] nps;
    Vector propProcs;
    SortedSet allActions;

    public LabelFactory(String string, FormulaFactory formulaFactory) {
        this.allprops = formulaFactory.getProps();
        this.fac = formulaFactory;
        this.name = string;
        this.tr = new HashMap();
        this.initPropSets();
        this.compileProps();
    }

    HashMap getTransLabels() {
        return this.tr;
    }

    Vector getPrefix() {
        Vector<String> vector = new Vector<String>();
        Formula formula = (Formula)this.allprops.first();
        vector.add("_" + formula);
        return vector;
    }

    String makeLabel(SortedSet sortedSet) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.allprops.iterator();
        boolean bl = false;
        BitSet bitSet = new BitSet();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Formula)iterator.next();
            if (sortedSet.contains(object)) {
                if (bl) {
                    stringBuffer.append("&");
                    bitSet.and(this.ps[n]);
                } else {
                    bitSet.or(this.ps[n]);
                    bl = true;
                }
                stringBuffer.append(object);
            } else if (sortedSet.contains(this.fac.makeNot((Formula)object))) {
                if (bl) {
                    stringBuffer.append("&");
                    bitSet.and(this.nps[n]);
                } else {
                    bitSet.or(this.nps[n]);
                    bl = true;
                }
                stringBuffer.append("!" + object);
            }
            ++n;
        }
        object = stringBuffer.toString();
        this.tr.put(object, bitSet);
        return object;
    }

    public String[] makeAlphabet() {
        return this.makeAlphabet(null, null, null);
    }

    private String[] makeAlphabet(PredicateDefinition predicateDefinition, BitSet bitSet, BitSet bitSet2) {
        Iterator iterator;
        int n = 0;
        n = predicateDefinition == null ? 1 : predicateDefinition.trueActions.size() + predicateDefinition.falseActions.size();
        int n2 = (1 << this.allprops.size()) + 1 + n;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2 - n) {
            StringBuffer stringBuffer = new StringBuffer();
            iterator = this.allprops.iterator();
            boolean bl = false;
            int n4 = 0;
            while (iterator.hasNext()) {
                Formula formula = (Formula)iterator.next();
                if (bl) {
                    stringBuffer.append(".");
                }
                bl = true;
                stringBuffer.append("_" + formula + "." + (n3 >> n4) % 2);
                ++n4;
            }
            stringArray[n3 + 1] = stringBuffer.toString();
            ++n3;
        }
        stringArray[0] = "tau";
        if (predicateDefinition == null) {
            stringArray[n2 - 1] = "@" + this.name;
        } else {
            int n5 = n2 - n;
            iterator = predicateDefinition.falseActions.iterator();
            while (iterator.hasNext()) {
                stringArray[n5] = (String)iterator.next();
                bitSet2.set(n5);
                ++n5;
            }
            iterator = predicateDefinition.trueActions.iterator();
            while (iterator.hasNext()) {
                stringArray[n5] = (String)iterator.next();
                bitSet.set(n5);
                ++n5;
            }
        }
        return stringArray;
    }

    void initPropSets() {
        int n = this.allprops.size();
        this.ps = new BitSet[n];
        this.nps = new BitSet[n];
        BitSet bitSet = new BitSet(1 << n);
        int n2 = 0;
        while (n2 < n) {
            this.ps[n2] = new BitSet(1 << n);
            this.nps[n2] = new BitSet(1 << n);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 1 << n) {
            bitSet.set(n3);
            int n4 = 0;
            while (n4 < n) {
                if ((n3 >> n4) % 2 == 1) {
                    this.ps[n4].set(n3);
                } else {
                    this.nps[n4].set(n3);
                }
                ++n4;
            }
            ++n3;
        }
        this.tr.put("true", bitSet);
    }

    protected void compileProps() {
        this.propProcs = new Vector();
        this.allActions = new TreeSet();
        Iterator iterator = this.allprops.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Proposition proposition = (Proposition)iterator.next();
            PredicateDefinition predicateDefinition = PredicateDefinition.get(proposition.toString());
            if (predicateDefinition == null) {
                Diagnostics.fatal("Proposition " + proposition + " not found", proposition.sym);
            }
            this.allActions.addAll(predicateDefinition.trueActions);
            this.allActions.addAll(predicateDefinition.falseActions);
            this.propProcs.add(this.makePropProcess(predicateDefinition, n));
            ++n;
        }
        this.propProcs.add(this.makeSyncProcess());
    }

    CompactState makePropProcess(PredicateDefinition predicateDefinition, int n) {
        CompactState compactState = new CompactState();
        compactState.name = predicateDefinition.name.toString();
        compactState.maxStates = 2;
        compactState.states = new EventState[compactState.maxStates];
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        compactState.alphabet = this.makeAlphabet(predicateDefinition, bitSet, bitSet2);
        int n2 = predicateDefinition.initial ? 1 : 0;
        int n3 = predicateDefinition.initial ? 0 : 1;
        int n4 = 0;
        while (n4 < bitSet.size()) {
            if (bitSet.get(n4)) {
                compactState.states[n2] = EventState.add(compactState.states[n2], new EventState(n4, n3));
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < bitSet2.size()) {
            if (bitSet2.get(n5)) {
                compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n5, n2));
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < bitSet2.size()) {
            if (bitSet2.get(n6)) {
                compactState.states[n2] = EventState.add(compactState.states[n2], new EventState(n6, n2));
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < bitSet.size()) {
            if (bitSet.get(n7)) {
                compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n7, n3));
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.nps[n].size()) {
            if (this.nps[n].get(n8)) {
                compactState.states[n2] = EventState.add(compactState.states[n2], new EventState(n8 + 1, n2));
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < this.ps[n].size()) {
            if (this.ps[n].get(n9)) {
                compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n9 + 1, n3));
            }
            ++n9;
        }
        return compactState;
    }

    CompactState makeSyncProcess() {
        CompactState compactState = new CompactState();
        compactState.name = "SYNC";
        compactState.maxStates = 2;
        compactState.states = new EventState[compactState.maxStates];
        String[] stringArray = this.makeAlphabet();
        String[] stringArray2 = new String[this.allActions.size()];
        int n = 0;
        Iterator iterator = this.allActions.iterator();
        while (iterator.hasNext()) {
            stringArray2[n++] = (String)iterator.next();
        }
        compactState.alphabet = new String[stringArray.length - 1 + stringArray2.length];
        compactState.alphabet[0] = "tau";
        int n2 = 1;
        while (n2 < stringArray.length - 1) {
            compactState.alphabet[n2] = stringArray[n2];
            compactState.states[0] = EventState.add(compactState.states[0], new EventState(n2, 1));
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            compactState.alphabet[n3 + stringArray.length - 1] = stringArray2[n3];
            compactState.states[1] = EventState.add(compactState.states[1], new EventState(n3 + stringArray.length - 1, 0));
            ++n3;
        }
        return compactState;
    }
}

