/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.And;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.GeneralizedBuchiAutomata;
import ic.doc.ltsa.lts.ltl.Next;
import ic.doc.ltsa.lts.ltl.Or;
import ic.doc.ltsa.lts.ltl.Release;
import ic.doc.ltsa.lts.ltl.State;
import ic.doc.ltsa.lts.ltl.Transition;
import ic.doc.ltsa.lts.ltl.True;
import ic.doc.ltsa.lts.ltl.Until;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Node
implements Comparable {
    int id = aut.newId();
    int equivId = -1;
    SortedSet incoming;
    SortedSet oldf;
    SortedSet newf;
    SortedSet next;
    BitSet accepting;
    BitSet rightOfU;
    static FormulaFactory fac;
    static GeneralizedBuchiAutomata aut;
    private Node otherSource = null;
    private static boolean collapsed;

    static void setAut(GeneralizedBuchiAutomata generalizedBuchiAutomata) {
        aut = generalizedBuchiAutomata;
    }

    static void setFactory(FormulaFactory formulaFactory) {
        fac = formulaFactory;
    }

    public Node() {
        this(null, null, null, null, null, null);
    }

    public Node(SortedSet sortedSet, SortedSet sortedSet2, SortedSet sortedSet3, SortedSet sortedSet4, BitSet bitSet, BitSet bitSet2) {
        this.incoming = sortedSet != null ? new TreeSet(sortedSet) : new TreeSet();
        this.oldf = sortedSet2 != null ? new TreeSet(sortedSet2) : new TreeSet();
        this.newf = sortedSet3 != null ? new TreeSet(sortedSet3) : new TreeSet();
        this.next = sortedSet4 != null ? new TreeSet(sortedSet4) : new TreeSet();
        this.accepting = new BitSet();
        if (bitSet != null) {
            this.accepting.or(bitSet);
        }
        this.rightOfU = new BitSet();
        if (bitSet2 != null) {
            this.rightOfU.or(bitSet2);
        }
    }

    public Node(Formula formula) {
        this();
        collapsed = false;
        if (!(formula instanceof True)) {
            this.decomposeAndforNext(formula);
        }
    }

    public int compareTo(Object object) {
        return this.id - ((Node)object).id;
    }

    public void decomposeAndforNext(Formula formula) {
        if (formula instanceof And) {
            this.decomposeAndforNext(((And)formula).getLeft());
            this.decomposeAndforNext(((And)formula).getRight());
        } else if (!this.isRedundant(this.next, null, formula)) {
            this.next.add(formula);
        }
    }

    private boolean isRedundant(SortedSet sortedSet, SortedSet sortedSet2, Formula formula) {
        return fac.specialCaseV(formula, sortedSet) || fac.syntaxImplied(formula, sortedSet, sortedSet2) && (!(formula instanceof Until) || fac.syntaxImplied(formula.getSub2(), sortedSet, sortedSet2));
    }

    private Node split(Formula formula) {
        Node node = new Node(this.incoming, this.oldf, this.newf, this.next, this.accepting, this.rightOfU);
        Formula formula2 = formula.getSub2();
        if (!this.oldf.contains(formula2)) {
            node.newf.add(formula2);
        }
        if (formula instanceof Release && !this.oldf.contains(formula2 = formula.getSub1())) {
            node.newf.add(formula2);
        }
        if (!this.oldf.contains(formula2 = formula.getSub1())) {
            this.newf.add(formula2);
        }
        Formula formula3 = formula2 = formula instanceof Until || formula instanceof Release ? formula : null;
        if (formula2 != null) {
            this.decomposeAndforNext(formula2);
        }
        if (formula instanceof Until) {
            this.accepting.set(formula.getUI());
            node.accepting.set(formula.getUI());
        }
        if (formula.isRightOfUntil()) {
            this.rightOfU.set(formula.getRofUI());
            node.rightOfU.set(formula.getRofUI());
        }
        if (formula.isLiteral()) {
            this.oldf.add(formula);
            node.oldf.add(formula);
        }
        return node;
    }

    public List expand(List list) {
        if (this.newf.isEmpty()) {
            Node node;
            if (this.id != 0) {
                this.accepting.andNot(this.rightOfU);
            }
            if ((node = this.alreadyThere(list)) != null) {
                node.modify(this);
                return list;
            }
            Node node2 = new Node();
            node2.incoming.add(this);
            node2.newf.addAll(this.next);
            list.add(this);
            return node2.expand(list);
        }
        Formula formula = (Formula)this.newf.first();
        this.newf.remove(formula);
        if (this.contradiction(formula)) {
            return list;
        }
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.oldf);
        treeSet.addAll(this.newf);
        if (this.isRedundant(treeSet, this.next, formula)) {
            return this.expand(list);
        }
        if (!formula.isLiteral()) {
            if (formula instanceof Or || formula instanceof Until || formula instanceof Release) {
                Node node = this.split(formula);
                return node.expand(this.expand(list));
            }
            if (formula instanceof And) {
                Formula formula2 = formula.getSub1();
                if (!this.oldf.contains(formula2)) {
                    this.newf.add(formula2);
                }
                if (!this.oldf.contains(formula2 = formula.getSub2())) {
                    this.newf.add(formula2);
                }
                if (formula.isRightOfUntil()) {
                    this.rightOfU.set(formula.getRofUI());
                }
                return this.expand(list);
            }
            if (formula instanceof Next) {
                this.decomposeAndforNext(formula.getSub1());
                if (formula.isRightOfUntil()) {
                    this.rightOfU.set(formula.getRofUI());
                }
                return this.expand(list);
            }
        }
        if (!(formula instanceof True)) {
            this.oldf.add(formula);
        }
        if (formula.isRightOfUntil()) {
            this.rightOfU.set(formula.getRofUI());
        }
        return this.expand(list);
    }

    private boolean contradiction(Formula formula) {
        return fac.syntaxImplied(fac.makeNot(formula), this.oldf, this.next);
    }

    private Node alreadyThere(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!this.next.equals(node.next) || !this.compareAccepting(node)) continue;
            return node;
        }
        return null;
    }

    private boolean compareAccepting(Node node) {
        if (this.id == 0 && !collapsed) {
            return true;
        }
        return this.accepting.equals(node.accepting);
    }

    static void printFormulaSet(LTSOutput lTSOutput, String string, SortedSet sortedSet) {
        lTSOutput.out(string + ":- ");
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Formula formula = (Formula)iterator.next();
            lTSOutput.out(formula.toString() + ", ");
        }
    }

    static void printIdSet(LTSOutput lTSOutput, String string, SortedSet sortedSet) {
        lTSOutput.out(string + ":- ");
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            lTSOutput.out(node.id + ", ");
        }
        lTSOutput.outln(".");
    }

    void printNode(LTSOutput lTSOutput) {
        lTSOutput.outln("\nNODE " + this.id + " equivId " + this.equivId);
        Node.printIdSet(lTSOutput, "INCOMING", this.incoming);
        Node.printFormulaSet(lTSOutput, "NEW", this.newf);
        lTSOutput.outln(".");
        Node.printFormulaSet(lTSOutput, "OLD", this.oldf);
        lTSOutput.outln(".");
        Node.printFormulaSet(lTSOutput, "NEXT", this.next);
        lTSOutput.outln(".");
        lTSOutput.outln("ACCEPTING:- " + this.accepting);
        lTSOutput.outln("RIGHTOFU:- " + this.rightOfU);
        if (this.otherSource != null) {
            lTSOutput.outln("OTHERSOURCE " + this.otherSource.id + " ************** ");
            Node node = this.otherSource;
            while (node != null) {
                node.printNode(lTSOutput);
                node = node.otherSource;
                if (node == this) break;
            }
        }
    }

    private void modify(Node node) {
        boolean bl = false;
        Node node2 = this;
        Node node3 = this;
        if (this.id == 0 && !collapsed) {
            this.accepting = node.accepting;
            collapsed = true;
        }
        while (node3 != null) {
            if (node3.oldf.equals(node.oldf)) {
                node3.incoming.addAll(node.incoming);
                bl = true;
            }
            node2 = node3;
            node3 = node3.otherSource;
        }
        if (!bl) {
            node2.otherSource = node;
        }
    }

    private boolean isSafetyAcc() {
        if (this.next.isEmpty()) {
            return true;
        }
        Iterator iterator = this.next.iterator();
        while (iterator.hasNext()) {
            Formula formula = (Formula)iterator.next();
            if (formula instanceof Release) continue;
            return false;
        }
        return true;
    }

    public void makeTransitions(State[] stateArray) {
        boolean bl = false;
        if (stateArray[this.id] == null) {
            stateArray[this.id] = new State(this.equivId);
        } else {
            stateArray[this.id].setId(this.equivId);
        }
        boolean bl2 = this.isSafetyAcc();
        Node node = this;
        while (node != null) {
            Iterator iterator = node.incoming.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                int n = node2.id;
                if (stateArray[n] == null) {
                    stateArray[n] = new State();
                }
                stateArray[n].add(new Transition(node.oldf, this.equivId, this.accepting, bl2));
            }
            node = node.otherSource;
        }
    }

    static {
        collapsed = false;
    }
}

