/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Symbol;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public class PredicateDefinition {
    Symbol name;
    ActionLabels trueSet;
    ActionLabels falseSet;
    Vector trueActions;
    Vector falseActions;
    Stack expr;
    boolean initial;
    static Hashtable definitions;

    private PredicateDefinition(Symbol symbol, ActionLabels actionLabels, ActionLabels actionLabels2, Stack stack) {
        this.name = symbol;
        this.trueSet = actionLabels;
        this.falseSet = actionLabels2;
        this.expr = stack;
        this.initial = false;
    }

    public static void put(Symbol symbol, ActionLabels actionLabels, ActionLabels actionLabels2, Stack stack) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (definitions.put(symbol.toString(), new PredicateDefinition(symbol, actionLabels, actionLabels2, stack)) != null) {
            Diagnostics.fatal("duplicate LTL predicate definition: " + symbol, symbol);
        }
    }

    public static void init() {
        definitions = null;
    }

    public static PredicateDefinition get(String string) {
        if (definitions == null) {
            return null;
        }
        PredicateDefinition predicateDefinition = (PredicateDefinition)definitions.get(string);
        if (predicateDefinition == null) {
            Diagnostics.fatal("Predicate " + string + " not found");
        }
        predicateDefinition.trueActions = predicateDefinition.trueSet.getActions(null, null);
        predicateDefinition.falseActions = predicateDefinition.falseSet.getActions(null, null);
        TreeSet treeSet = new TreeSet(predicateDefinition.trueActions);
        treeSet.retainAll(predicateDefinition.falseActions);
        if (!treeSet.isEmpty()) {
            Diagnostics.fatal("Predicate " + predicateDefinition.name + " True & False sets must be disjoint", predicateDefinition.name);
        }
        if (predicateDefinition.expr != null) {
            int n = Expression.evaluate(predicateDefinition.expr, null, null);
            predicateDefinition.initial = n > 0;
        }
        return predicateDefinition;
    }
}

