/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.custom;

import ic.doc.extension.Relation;
import ic.doc.ltsa.custom.AnimationAction;
import ic.doc.ltsa.custom.AnimationMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OutputActionRegistry {
    Hashtable outputs = new Hashtable();
    Relation actionMap;
    AnimationMessage msg;

    public OutputActionRegistry(Relation relation, AnimationMessage animationMessage) {
        this.actionMap = relation;
        this.msg = animationMessage;
    }

    public void register(String string, AnimationAction animationAction) {
        Vector<AnimationAction> vector = (Vector<AnimationAction>)this.outputs.get(string);
        if (vector != null) {
            vector.addElement(animationAction);
        } else {
            vector = new Vector<AnimationAction>();
            vector.addElement(animationAction);
            this.outputs.put(string, vector);
        }
    }

    public void doAction(String string) {
        this.msg.traceMsg(string);
        Object object = this.actionMap.get((Object)string);
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.execute((String)object);
        } else {
            Vector vector = (Vector)object;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.execute((String)enumeration.nextElement());
            }
        }
    }

    private void execute(String string) {
        this.msg.debugMsg("-action -" + string);
        Vector vector = (Vector)this.outputs.get(string);
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AnimationAction animationAction = (AnimationAction)enumeration.nextElement();
            animationAction.action();
        }
    }
}

