/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

class CJKFont
extends BaseFont {
    static final String CJK_ENCODING = "UnicodeBigUnmarked";
    private static final int FIRST = 0;
    private static final int BRACKET = 1;
    private static final int SERIAL = 2;
    private static final int V1Y = 880;
    static Properties cjkFonts = new Properties();
    static Properties cjkEncodings = new Properties();
    static Hashtable allCMaps = new Hashtable();
    static Hashtable allFonts = new Hashtable();
    private String fontName;
    private String style = "";
    private String CMap;
    private boolean cidDirect = false;
    private char[] translationMap;
    private IntHashtable vMetrics;
    private IntHashtable hMetrics;
    private HashMap fontDesc;
    private boolean vertical = false;

    CJKFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        this.fontType = 2;
        String string3 = BaseFont.getBaseName(string);
        if (!CJKFont.isCJKFont(string3, string2)) {
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' encoding is not a CJK font.");
        }
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
            string = string3;
        }
        this.fontName = string;
        this.encoding = CJK_ENCODING;
        this.vertical = string2.endsWith("V");
        this.CMap = string2;
        if (string2.startsWith("Identity-")) {
            this.cidDirect = true;
            String string4 = cjkFonts.getProperty(string);
            char[] cArray = (char[])allCMaps.get(string4 = string4.substring(0, string4.indexOf(95)));
            if (cArray == null) {
                cArray = CJKFont.readCMap(string4);
                if (cArray == null) {
                    throw new DocumentException("The cmap " + string4 + " does not exist as a resource.");
                }
                cArray[65280] = 10;
                allCMaps.put(string4, cArray);
            }
            this.translationMap = cArray;
        } else {
            char[] cArray = (char[])allCMaps.get(string2);
            if (cArray == null) {
                String string5 = cjkEncodings.getProperty(string2);
                if (string5 == null) {
                    throw new DocumentException("The resource cjkencodings.properties does not contain the encoding " + string2);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                String string6 = stringTokenizer.nextToken();
                cArray = (char[])allCMaps.get(string6);
                if (cArray == null) {
                    cArray = CJKFont.readCMap(string6);
                    allCMaps.put(string6, cArray);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    char[] cArray2 = CJKFont.readCMap(string7);
                    int n = 0;
                    while (n < 65536) {
                        if (cArray2[n] == '\u0000') {
                            cArray2[n] = cArray[n];
                        }
                        ++n;
                    }
                    allCMaps.put(string2, cArray2);
                    cArray = cArray2;
                }
            }
            this.translationMap = cArray;
        }
        this.fontDesc = (HashMap)allFonts.get(string);
        if (this.fontDesc == null) {
            this.fontDesc = CJKFont.readFontProperties(string);
            allFonts.put(string, this.fontDesc);
        }
        this.hMetrics = (IntHashtable)this.fontDesc.get("W");
        this.vMetrics = (IntHashtable)this.fontDesc.get("W2");
    }

    public static boolean isCJKFont(String string, String string2) {
        String string3 = cjkFonts.getProperty(string);
        return string3 != null && (string2.equals("Identity-H") || string2.equals("Identity-V") || string3.indexOf("_" + string2 + "_") >= 0);
    }

    public int getWidth(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            char c = string.charAt(n2);
            if (!this.cidDirect) {
                c = this.translationMap[c];
            }
            n = (n3 = this.vertical ? this.vMetrics.get(c) : this.hMetrics.get(c)) > 0 ? (n += n3) : (n += 1000);
            ++n2;
        }
        return n;
    }

    protected int getRawWidth(int n, String string) {
        return 0;
    }

    public int getKerning(char c, char c2) {
        return 0;
    }

    private PdfDictionary getFontDescriptor() {
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfLiteral((String)this.fontDesc.get("Ascent")));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfLiteral((String)this.fontDesc.get("CapHeight")));
        pdfDictionary.put(new PdfName("Descent"), new PdfLiteral((String)this.fontDesc.get("Descent")));
        pdfDictionary.put(new PdfName("Flags"), new PdfLiteral((String)this.fontDesc.get("Flags")));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfLiteral((String)this.fontDesc.get("FontBBox")));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(this.fontName + this.style));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfLiteral((String)this.fontDesc.get("ItalicAngle")));
        pdfDictionary.put(new PdfName("StemV"), new PdfLiteral((String)this.fontDesc.get("StemV")));
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.PANOSE, new PdfString((String)this.fontDesc.get("Panose"), null));
        pdfDictionary.put(new PdfName("Style"), pdfDictionary2);
        return pdfDictionary;
    }

    private PdfDictionary getCIDFont(PdfIndirectReference pdfIndirectReference, IntHashtable intHashtable) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("CIDFontType0"));
        pdfDictionary.put(new PdfName("BaseFont"), new PdfName(this.fontName + this.style));
        pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        int[] nArray = intHashtable.toOrderedKeys();
        String string = CJKFont.convertToHCIDMetrics(nArray, this.hMetrics);
        if (string != null) {
            pdfDictionary.put(new PdfName("W"), new PdfLiteral(string));
        }
        if (this.vertical && (string = CJKFont.convertToVCIDMetrics(nArray, this.vMetrics, this.hMetrics)) != null) {
            pdfDictionary.put(new PdfName("W2"), new PdfLiteral(string));
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.REGISTRY, new PdfString((String)this.fontDesc.get("Registry"), null));
        pdfDictionary2.put(PdfName.ORDERING, new PdfString((String)this.fontDesc.get("Ordering"), null));
        pdfDictionary2.put(PdfName.SUPPLEMENT, new PdfLiteral((String)this.fontDesc.get("Supplement")));
        pdfDictionary.put(new PdfName("CIDSystemInfo"), pdfDictionary2);
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, new PdfName("Type0"));
        String string = this.fontName;
        if (this.style.length() > 0) {
            string = string + "-" + this.style.substring(1);
        }
        string = string + "-" + this.CMap;
        pdfDictionary.put(new PdfName("BaseFont"), new PdfName(string));
        pdfDictionary.put(new PdfName("Encoding"), new PdfName(this.CMap));
        pdfDictionary.put(new PdfName("DescendantFonts"), new PdfArray(pdfIndirectReference));
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        IntHashtable intHashtable = (IntHashtable)objectArray[0];
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        pdfDictionary = this.getFontDescriptor();
        if (pdfDictionary != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfDictionary = this.getCIDFont(pdfIndirectReference2, intHashtable)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    private float getDescNumber(String string) {
        return Integer.parseInt((String)this.fontDesc.get(string));
    }

    private float getBBox(int n) {
        String string = (String)this.fontDesc.get("FontBBox");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []\r\n\t\f");
        String string2 = stringTokenizer.nextToken();
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        return Integer.parseInt(string2);
    }

    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: 
            case 9: {
                return this.getDescNumber("Ascent") * f / 1000.0f;
            }
            case 2: {
                return this.getDescNumber("CapHeight") * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.getDescNumber("Descent") * f / 1000.0f;
            }
            case 4: {
                return this.getDescNumber("ItalicAngle");
            }
            case 5: {
                return f * this.getBBox(0) / 1000.0f;
            }
            case 6: {
                return f * this.getBBox(1) / 1000.0f;
            }
            case 7: {
                return f * this.getBBox(2) / 1000.0f;
            }
            case 8: {
                return f * this.getBBox(3) / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return f * (this.getBBox(2) - this.getBBox(0)) / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    static char[] readCMap(String string) {
        try {
            string = string + ".cmap";
            InputStream inputStream = BaseFont.getResourceStream(string);
            char[] cArray = new char[65536];
            int n = 0;
            while (n < 65536) {
                cArray[n] = (char)((inputStream.read() << 8) + inputStream.read());
                ++n;
            }
            return cArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static IntHashtable createMetric(String string) {
        IntHashtable intHashtable = new IntHashtable();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            intHashtable.put(n, Integer.parseInt(stringTokenizer.nextToken()));
        }
        return intHashtable;
    }

    static String convertToHCIDMetrics(int[] nArray, IntHashtable intHashtable) {
        if (nArray.length == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            n = nArray[n3];
            n2 = intHashtable.get(n);
            if (n2 != 0) {
                ++n3;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(n);
        int n4 = 0;
        int n5 = n3;
        while (n5 < nArray.length) {
            int n6 = nArray[n5];
            int n7 = intHashtable.get(n6);
            if (n7 != 0) {
                switch (n4) {
                    case 0: {
                        if (n6 == n + 1 && n7 == n2) {
                            n4 = 2;
                            break;
                        }
                        if (n6 == n + 1) {
                            n4 = 1;
                            stringBuffer.append('[').append(n2);
                            break;
                        }
                        stringBuffer.append('[').append(n2).append(']').append(n6);
                        break;
                    }
                    case 1: {
                        if (n6 == n + 1 && n7 == n2) {
                            n4 = 2;
                            stringBuffer.append(']').append(n);
                            break;
                        }
                        if (n6 == n + 1) {
                            stringBuffer.append(' ').append(n2);
                            break;
                        }
                        n4 = 0;
                        stringBuffer.append(' ').append(n2).append(']').append(n6);
                        break;
                    }
                    case 2: {
                        if (n6 == n + 1 && n7 == n2) break;
                        stringBuffer.append(' ').append(n).append(' ').append(n2).append(' ').append(n6);
                        n4 = 0;
                    }
                }
                n2 = n7;
                n = n6;
            }
            ++n5;
        }
        switch (n4) {
            case 0: {
                stringBuffer.append('[').append(n2).append("]]");
                break;
            }
            case 1: {
                stringBuffer.append(' ').append(n2).append("]]");
                break;
            }
            case 2: {
                stringBuffer.append(' ').append(n).append(' ').append(n2).append(']');
            }
        }
        return stringBuffer.toString();
    }

    static String convertToVCIDMetrics(int[] nArray, IntHashtable intHashtable, IntHashtable intHashtable2) {
        if (nArray.length == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            n = nArray[n4];
            n2 = intHashtable.get(n);
            if (n2 != 0) {
                ++n4;
                break;
            }
            n3 = intHashtable2.get(n);
            ++n4;
        }
        if (n2 == 0) {
            return null;
        }
        if (n3 == 0) {
            n3 = 1000;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(n);
        int n5 = 0;
        int n6 = n4;
        while (n6 < nArray.length) {
            int n7 = nArray[n6];
            int n8 = intHashtable.get(n7);
            if (n8 != 0) {
                int n9 = intHashtable2.get(n);
                if (n9 == 0) {
                    n9 = 1000;
                }
                switch (n5) {
                    case 0: {
                        if (n7 == n + 1 && n8 == n2 && n9 == n3) {
                            n5 = 2;
                            break;
                        }
                        stringBuffer.append(' ').append(n).append(' ').append(-n2).append(' ').append(n3 / 2).append(' ').append(880).append(' ').append(n7);
                        break;
                    }
                    case 2: {
                        if (n7 == n + 1 && n8 == n2 && n9 == n3) break;
                        stringBuffer.append(' ').append(n).append(' ').append(-n2).append(' ').append(n3 / 2).append(' ').append(880).append(' ').append(n7);
                        n5 = 0;
                    }
                }
                n2 = n8;
                n = n7;
                n3 = n9;
            }
            ++n6;
        }
        stringBuffer.append(' ').append(n).append(' ').append(-n2).append(' ').append(n3 / 2).append(' ').append(880).append(" ]");
        return stringBuffer.toString();
    }

    static HashMap readFontProperties(String string) {
        try {
            string = string + ".properties";
            InputStream inputStream = BaseFont.getResourceStream(string);
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            IntHashtable intHashtable = CJKFont.createMetric(properties.getProperty("W"));
            ((Hashtable)properties).remove("W");
            IntHashtable intHashtable2 = CJKFont.createMetric(properties.getProperty("W2"));
            ((Hashtable)properties).remove("W2");
            HashMap hashMap = new HashMap();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                hashMap.put(k, properties.getProperty((String)k));
            }
            hashMap.put("W", intHashtable);
            hashMap.put("W2", intHashtable2);
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public char getUnicodeEquivalent(char c) {
        if (this.cidDirect) {
            return this.translationMap[c];
        }
        return c;
    }

    public char getCidCode(char c) {
        if (this.cidDirect) {
            return c;
        }
        return this.translationMap[c];
    }

    static {
        try {
            InputStream inputStream = BaseFont.getResourceStream("cjkfonts.properties");
            cjkFonts.load(inputStream);
            inputStream.close();
            inputStream = BaseFont.getResourceStream("cjkencodings.properties");
            cjkEncodings.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            cjkFonts = new Properties();
            cjkEncodings = new Properties();
            System.err.println("Missing configuration files for CJK fonts");
        }
    }
}

