/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

class PdfChunk
implements SplitCharacter {
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "PDF";
    protected PdfFont font;
    protected SplitCharacter splitCharacter;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    PdfChunk(String string, PdfChunk pdfChunk) {
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        BaseFont baseFont;
        this.value = chunk.content();
        Font font = chunk.font();
        float f = font.size();
        if (f == -1.0f) {
            f = 12.0f;
        }
        if ((baseFont = font.getBaseFont()) == null) {
            int n;
            int n2 = font.style();
            if (n2 == -1) {
                n2 = 0;
            }
            block0 : switch (font.family()) {
                case 0: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 1;
                            break block0;
                        }
                        case 2: {
                            n = 2;
                            break block0;
                        }
                        case 3: {
                            n = 3;
                            break block0;
                        }
                    }
                    n = 0;
                    break;
                }
                case 2: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 10;
                            break block0;
                        }
                        case 2: {
                            n = 11;
                            break block0;
                        }
                        case 3: {
                            n = 12;
                            break block0;
                        }
                    }
                    n = 9;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 13;
                    break;
                }
                default: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 5;
                            break block0;
                        }
                        case 2: {
                            n = 6;
                            break block0;
                        }
                        case 3: {
                            n = 7;
                            break block0;
                        }
                    }
                    n = 4;
                }
            }
            this.font = new PdfFont(n, f);
        } else {
            this.font = new PdfFont(baseFont, f);
        }
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (keysAttributes.containsKey(k)) {
                    this.attributes.put(k, hashMap.get(k));
                    continue;
                }
                if (!keysNoStroke.containsKey(k)) continue;
                this.noStroke.put(k, hashMap.get(k));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            this.attributes.put("UNDERLINE", null);
        }
        if (font.isStrikethru()) {
            this.attributes.put("STRIKETHRU", null);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    protected int getWord(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isLetter(string.charAt(n))) break;
            ++n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    PdfChunk split(float var1_1) {
        block19: {
            this.newlineSplit = false;
            if (this.image != null) {
                if (this.image.scaledWidth() > var1_1) {
                    var2_2 = new PdfChunk("\ufffc", this);
                    this.value = "";
                    this.attributes = new HashMap<K, V>();
                    this.image = null;
                    this.font = new PdfFont(4, 12.0f);
                    return var2_2;
                }
                return null;
            }
            var2_3 = (HyphenationEvent)this.noStroke.get("HYPHENATION");
            var3_4 = 0;
            var4_5 = -1;
            var5_6 = 0.0f;
            var6_7 = -1;
            var7_8 = 0.0f;
            var8_9 = this.value.length();
            var9_10 = '\u0000';
            var10_11 = this.font.getFont();
            if (var10_11.getFontType() != 2 || var10_11.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl63
            while (var3_4 < var8_9) {
                var11_12 = this.value.charAt(var3_4);
                var9_10 = var10_11.getUnicodeEquivalent(var11_12);
                if (var9_10 == '\n') {
                    this.newlineSplit = true;
                    var12_16 = this.value.substring(var3_4 + 1);
                    this.value = this.value.substring(0, var3_4);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    var13_20 = new PdfChunk(var12_16, this);
                    return var13_20;
                }
                var5_6 += this.font.width(var11_12);
                if (var9_10 == ' ') {
                    var6_7 = var3_4 + 1;
                    var7_8 = var5_6;
                }
                if (!(var5_6 > var1_1)) {
                    if (this.splitCharacter.isSplitCharacter(var9_10)) {
                        var4_5 = var3_4 + 1;
                    }
                    ++var3_4;
                    continue;
                }
                break block19;
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                var9_10 = this.value.charAt(var3_4);
                if (var9_10 == '\r' || var9_10 == '\n') {
                    this.newlineSplit = true;
                    var11_13 = 1;
                    if (var9_10 == '\r' && var3_4 + 1 < var8_9 && this.value.charAt(var3_4 + 1) == '\n') {
                        var11_13 = 2;
                    }
                    var12_17 = this.value.substring(var3_4 + var11_13);
                    this.value = this.value.substring(0, var3_4);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    var13_21 = new PdfChunk(var12_17, this);
                    return var13_21;
                }
                var5_6 += this.font.width(var9_10);
                if (var9_10 == ' ') {
                    var6_7 = var3_4 + 1;
                    var7_8 = var5_6;
                }
                if (var5_6 > var1_1) break;
                if (this.splitCharacter.isSplitCharacter(var9_10)) {
                    var4_5 = var3_4 + 1;
                }
                ++var3_4;
lbl63:
                // 2 sources

                ** while (var3_4 < var8_9)
            }
        }
        if (var3_4 == var8_9) {
            return null;
        }
        if (var4_5 < 0) {
            var11_14 = this.value;
            this.value = "";
            var12_18 = new PdfChunk(var11_14, this);
            return var12_18;
        }
        if (var6_7 > var4_5 && this.splitCharacter.isSplitCharacter(' ')) {
            var4_5 = var6_7;
        }
        if (var2_3 != null && var6_7 < var3_4 && (var11_12 = this.getWord(this.value, var6_7)) > var6_7) {
            var12_19 = var2_3.getHyphenatedWordPre(this.value.substring(var6_7, var11_12), this.font.getFont(), this.font.size(), var1_1 - var7_8);
            var13_22 = var2_3.getHyphenatedWordPost();
            if (var13_22.length() > 0) {
                var14_23 = var13_22 + this.value.substring(var11_12);
                this.value = this.trim(this.value.substring(0, var6_7) + (String)var12_19);
                var15_24 = new PdfChunk(var14_23, this);
                return var15_24;
            }
        }
        var11_15 = this.value.substring(var4_5);
        this.value = this.trim(this.value.substring(0, var4_5));
        var12_19 = new PdfChunk(var11_15, this);
        return var12_19;
    }

    PdfChunk truncate(float f) {
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = new PdfFont(4, 12.0f);
                return pdfChunk;
            }
            return null;
        }
        int n = 0;
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n2 = this.value.length();
        while (n < n2) {
            char c = this.value.charAt(n);
            if ((f2 += this.font.width(c)) > f) break;
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if (n == 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        if (this.image != null) {
            return this.image.scaledWidth();
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size());
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.scaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size()) + (float)this.value.length() * f + (float)n * f2;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f) {
        this.offsetX = f;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f) {
        this.offsetY = f;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    public boolean isSplitCharacter(char c) {
        if (c <= ' ' || c == '-') {
            return true;
        }
        if (c < '\u2e80') {
            return false;
        }
        return c >= '\u2e80' && c < '\ud7a0' || c >= '\uf900' && c < '\ufb00' || c >= '\ufe30' && c < '\ufe50' || c >= '\uff61' && c < '\uffa0';
    }

    boolean isExtSplitCharacter(char c) {
        return this.splitCharacter.isSplitCharacter(c);
    }

    /*
     * Unable to fully structure code
     */
    String trim(String var1_1) {
        block2: {
            var2_2 = this.font.getFont();
            if (var2_2.getFontType() != 2 || var2_2.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl8
            while (var1_1.endsWith("\u0001")) {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
lbl8:
                // 2 sources

                ** while (var1_1.endsWith((String)" ") || var1_1.endsWith((String)"\t"))
            }
        }
        return var1_1;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    float getCharWidth(char c) {
        if (PdfChunk.noPrint(c)) {
            return 0.0f;
        }
        return this.font.width(c);
    }

    public static boolean noPrint(char c) {
        return c >= '\u200b' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e';
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("STRIKETHRU", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
    }
}

