/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.cli.CommandLineArgParser;
import org.scribble.cli.CommandLineException;
import org.scribble.main.MainContext;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.DirectoryResourceLocator;
import org.scribble.main.resource.ResourceLocator;
import org.scribble.model.local.EndpointGraph;
import org.scribble.model.wf.WFState;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ScribParserException;
import org.scribble.util.ScribUtil;
import org.scribble.visit.Job;
import org.scribble.visit.JobContext;

public class CommandLine {
    private final Map<ArgFlag, String[]> args;

    public CommandLine(String ... args) throws CommandLineException {
        this.args = new CommandLineArgParser(args).getArgs();
        if (!this.args.containsKey((Object)ArgFlag.MAIN)) {
            throw new CommandLineException("No main module has been specified\r\n");
        }
    }

    public static void main(String[] args) throws CommandLineException, ScribbleException {
        try {
            new CommandLine(args).run();
        }
        catch (CommandLineException | ScribParserException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (RuntimeScribbleException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public void run() throws ScribbleException, CommandLineException, ScribParserException {
        try {
            ScribbleException fail;
            Job job;
            block20: {
                job = this.newJob(this.newMainContext());
                fail = null;
                try {
                    job.checkWellFormedness();
                }
                catch (ScribbleException x) {
                    fail = x;
                }
                try {
                    if (this.args.containsKey((Object)ArgFlag.PROJECT)) {
                        this.outputProjections(job);
                    }
                    if (this.args.containsKey((Object)ArgFlag.FSM)) {
                        this.outputGraph(job, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.FSM_DOT)) {
                        this.drawGraph(job, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.CHECKED_FSM)) {
                        this.outputGraph(job, false);
                    }
                    if (this.args.containsKey((Object)ArgFlag.CHECKED_FSM_DOT)) {
                        this.drawGraph(job, false);
                    }
                    if (this.args.containsKey((Object)ArgFlag.GLOBAL_MODEL) || this.args.containsKey((Object)ArgFlag.GLOBAL_MODEL_DOT)) {
                        if (job.useOldWf) {
                            throw new CommandLineException("Incompatible flags: -model and -oldwf");
                        }
                        if (this.args.containsKey((Object)ArgFlag.GLOBAL_MODEL)) {
                            this.outputGlobalModel(job);
                        }
                        if (this.args.containsKey((Object)ArgFlag.GLOBAL_MODEL_DOT)) {
                            this.drawGlobalModel(job);
                        }
                    }
                }
                catch (ScribbleException x) {
                    if (fail != null) break block20;
                    fail = x;
                }
            }
            if (fail != null) {
                throw fail;
            }
            if (this.args.containsKey((Object)ArgFlag.SESS_API)) {
                this.outputSessionApi(job);
            }
            if (this.args.containsKey((Object)ArgFlag.SCHAN_API)) {
                this.outputStateChannelApi(job);
            }
            if (this.args.containsKey((Object)ArgFlag.EP_API)) {
                this.outputEndpointApi(job);
            }
        }
        catch (ScribbleException e) {
            if (this.args.containsKey((Object)ArgFlag.JUNIT) || this.args.containsKey((Object)ArgFlag.VERBOSE)) {
                throw e;
            }
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void outputProjections(Job job) throws CommandLineException, ScribbleException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.PROJECT);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map projections = job.getProjections(fullname, role);
            System.out.println("\n" + projections.values().stream().map(p -> p.toString()).collect(Collectors.joining("\n\n")));
            i += 2;
        }
    }

    private void outputGraph(Job job, boolean forUser) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = forUser ? this.args.get((Object)ArgFlag.FSM) : this.args.get((Object)ArgFlag.CHECKED_FSM);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            EndpointGraph fsm = this.getEndointGraph(forUser, job, fullname, role);
            System.out.println("\n" + fsm);
            i += 2;
        }
    }

    private void drawGraph(Job job, boolean forUser) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = forUser ? this.args.get((Object)ArgFlag.FSM_DOT) : this.args.get((Object)ArgFlag.CHECKED_FSM_DOT);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            String png = args[i + 2];
            EndpointGraph fsm = this.getEndointGraph(forUser, job, fullname, role);
            CommandLine.runDot(fsm.init.toDot(), png);
            i += 3;
        }
    }

    private void outputGlobalModel(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.GLOBAL_MODEL);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            WFState model = CommandLine.getGlobalModel(job, fullname);
            System.out.println("\n" + model.toDot());
            ++i;
        }
    }

    private void drawGlobalModel(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.GLOBAL_MODEL_DOT);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            String png = args[i + 1];
            WFState model = CommandLine.getGlobalModel(job, fullname);
            CommandLine.runDot(model.toDot(), png);
            i += 2;
        }
    }

    private static WFState getGlobalModel(Job job, GProtocolName fullname) throws ScribbleException {
        JobContext jcontext = job.getContext();
        WFState model = jcontext.getGlobalModel(fullname);
        if (model == null) {
            throw new ScribbleException("Shouldn't see this: " + fullname);
        }
        return model;
    }

    private void outputSessionApi(Job job) throws ScribbleException, CommandLineException {
        String[] args;
        JobContext jcontext = job.getContext();
        String[] stringArray = args = this.args.get((Object)ArgFlag.SESS_API);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String fullname = stringArray[n2];
            GProtocolName gpn = CommandLine.checkGlobalProtocolArg(jcontext, fullname);
            Map classes = job.generateSessionApi(gpn);
            this.outputClasses(classes);
            ++n2;
        }
    }

    private void outputStateChannelApi(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.SCHAN_API);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map classes = job.generateStateChannelApi(fullname, role, this.args.containsKey((Object)ArgFlag.SCHAN_API_SUBTYPES));
            this.outputClasses(classes);
            i += 2;
        }
    }

    private void outputEndpointApi(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.EP_API);
        int i = 0;
        while (i < args.length) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Map sessClasses = job.generateSessionApi(fullname);
            this.outputClasses(sessClasses);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map scClasses = job.generateStateChannelApi(fullname, role, this.args.containsKey((Object)ArgFlag.SCHAN_API_SUBTYPES));
            this.outputClasses(scClasses);
            i += 2;
        }
    }

    private void outputClasses(Map<String, String> classes) throws ScribbleException {
        Consumer<String> f;
        if (this.args.containsKey((Object)ArgFlag.API_OUTPUT)) {
            String dir = this.args.get((Object)ArgFlag.API_OUTPUT)[0];
            f = path -> ScribUtil.handleLambdaScribbleException(() -> {
                String tmp = String.valueOf(dir) + "/" + path;
                if (this.args.containsKey((Object)ArgFlag.VERBOSE)) {
                    System.out.println("\n[DEBUG] Writing to: " + tmp);
                }
                ScribUtil.writeToFile((String)tmp, (String)((String)classes.get(path)));
                return null;
            });
        } else {
            f = path -> System.out.println(String.valueOf(path) + ":\n" + (String)classes.get(path));
        }
        classes.keySet().stream().forEach(f);
    }

    private static void runDot(String dot, String png) throws ScribbleException, CommandLineException {
        String tmpName = String.valueOf(png) + ".tmp";
        File tmp = new File(tmpName);
        if (tmp.exists()) {
            throw new CommandLineException("Cannot overwrite: " + tmpName);
        }
        try {
            ScribUtil.writeToFile((String)tmpName, (String)dot);
            String[] res = ScribUtil.runProcess((String[])new String[]{"dot", "-Tpng", "-o" + png, tmpName});
            System.out.print(!res[1].isEmpty() ? res[1] : res[0]);
        }
        finally {
            tmp.delete();
        }
    }

    private EndpointGraph getEndointGraph(boolean forUser, Job job, GProtocolName fullname, Role role) throws ScribbleException, CommandLineException {
        EndpointGraph graph;
        JobContext jcontext = job.getContext();
        GProtocolDecl gpd = (GProtocolDecl)jcontext.getMainModule().getProtocolDecl((ProtocolName)fullname.getSimpleName());
        if (gpd == null || !gpd.header.roledecls.getRoles().contains(role)) {
            throw new CommandLineException("Bad FSM construction args: " + Arrays.toString(this.args.get((Object)ArgFlag.FSM)));
        }
        if (forUser) {
            graph = this.args.containsKey((Object)ArgFlag.MIN_EFSM) ? jcontext.getMinimisedEndpointGraph(fullname, role) : jcontext.getEndpointGraph(fullname, role);
        } else {
            EndpointGraph endpointGraph = graph = !this.args.containsKey((Object)ArgFlag.FAIR) && !this.args.containsKey((Object)ArgFlag.NO_LIVENESS) ? jcontext.getUnfairEndpointGraph(fullname, role) : jcontext.getEndpointGraph(fullname, role);
        }
        if (graph == null) {
            throw new ScribbleException("Shouldn't see this: " + fullname);
        }
        return graph;
    }

    private Job newJob(MainContext mc) {
        return mc.newJob();
    }

    private MainContext newMainContext() throws ScribParserException, ScribbleException {
        boolean debug = this.args.containsKey((Object)ArgFlag.VERBOSE);
        boolean useOldWF = this.args.containsKey((Object)ArgFlag.OLD_WF);
        boolean noLiveness = this.args.containsKey((Object)ArgFlag.NO_LIVENESS);
        boolean minEfsm = this.args.containsKey((Object)ArgFlag.MIN_EFSM);
        boolean fair = this.args.containsKey((Object)ArgFlag.FAIR);
        boolean noLocalChoiceSubjectCheck = this.args.containsKey((Object)ArgFlag.NO_LOCAL_CHOICE_SUBJECT_CHECK);
        Path mainpath = CommandLine.parseMainPath(this.args.get((Object)ArgFlag.MAIN)[0]);
        List impaths = this.args.containsKey((Object)ArgFlag.PATH) ? CommandLine.parseImportPaths(this.args.get((Object)ArgFlag.PATH)[0]) : Collections.emptyList();
        DirectoryResourceLocator locator = new DirectoryResourceLocator(impaths);
        return new MainContext(debug, (ResourceLocator)locator, mainpath, useOldWF, noLiveness, minEfsm, fair, noLocalChoiceSubjectCheck);
    }

    private static Path parseMainPath(String path) {
        return Paths.get(path, new String[0]);
    }

    private static List<Path> parseImportPaths(String paths) {
        return Arrays.stream(paths.split(File.pathSeparator)).map(s -> Paths.get(s, new String[0])).collect(Collectors.toList());
    }

    private static GProtocolName checkGlobalProtocolArg(JobContext jcontext, String simpname) throws CommandLineException {
        GProtocolName simpgpn = new GProtocolName(simpname);
        Module main = jcontext.getMainModule();
        if (!main.hasProtocolDecl((ProtocolName)simpgpn)) {
            throw new CommandLineException("Global protocol not found: " + simpname);
        }
        ProtocolDecl pd = main.getProtocolDecl((ProtocolName)simpgpn);
        if (pd == null || !pd.isGlobal()) {
            throw new CommandLineException("Global protocol not found: " + simpname);
        }
        return new GProtocolName(jcontext.main, (ProtocolName)simpgpn);
    }

    private static Role checkRoleArg(JobContext jcontext, GProtocolName fullname, String rolename) throws CommandLineException {
        ProtocolDecl pd = jcontext.getMainModule().getProtocolDecl((ProtocolName)fullname.getSimpleName());
        Role role = new Role(rolename);
        if (!pd.header.roledecls.getRoles().contains(role)) {
            throw new CommandLineException("Role not declared for " + fullname + ": " + role);
        }
        return role;
    }

    protected static enum ArgFlag {
        MAIN,
        PATH,
        PROJECT,
        JUNIT,
        VERBOSE,
        FSM,
        FSM_DOT,
        CHECKED_FSM,
        CHECKED_FSM_DOT,
        SESS_API,
        SCHAN_API,
        EP_API,
        API_OUTPUT,
        SCHAN_API_SUBTYPES,
        GLOBAL_MODEL,
        GLOBAL_MODEL_DOT,
        OLD_WF,
        NO_LIVENESS,
        MIN_EFSM,
        FAIR,
        NO_LOCAL_CHOICE_SUBJECT_CHECK;

    }
}

