/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.cli;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.scribble.cli.CommandLine;
import org.scribble.cli.CommandLineException;

public class CommandLineArgParser {
    public static final String JUNIT_FLAG = "-junit";
    public static final String VERBOSE_FLAG = "-V";
    public static final String PATH_FLAG = "-ip";
    public static final String PROJECT_FLAG = "-project";
    public static final String FSM_FLAG = "-fsm";
    public static final String FSM_DOT_FLAG = "-fsmdot";
    public static final String CHECKED_FSM_FLAG = "-vfsm";
    public static final String CHECKED_FSM_DOT_FLAG = "-vfsmdot";
    public static final String SESSION_FLAG = "-session";
    public static final String STATECHAN_FLAG = "-schan";
    public static final String API_FLAG = "-api";
    public static final String API_OUTPUT_FLAG = "-d";
    public static final String STATECHANSUBTYPES_FLAG = "-subtypes";
    public static final String GLOBAL_MODEL_FLAG = "-model";
    public static final String GLOBAL_MODEL_DOT_FLAG = "-modeldot";
    public static final String OLD_WF_FLAG = "-oldwf";
    public static final String NO_LIVENESS_FLAG = "-nolive";
    public static final String MIN_EFSM_FLAG = "-minfsm";
    public static final String FAIR_FLAG = "-fair";
    public static final String NO_LOCAL_CHOICE_SUBJECT_CHECK = "-nolocalchoicecheck";
    private static final Map<String, CommandLine.ArgFlag> UNIQUE_FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private static final Map<String, CommandLine.ArgFlag> NON_UNIQUE_FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private static final Map<String, CommandLine.ArgFlag> FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private final String[] args;
    private final Map<CommandLine.ArgFlag, String[]> parsed;

    public CommandLineArgParser(String[] args) throws CommandLineException {
        UNIQUE_FLAGS.put(JUNIT_FLAG, CommandLine.ArgFlag.JUNIT);
        UNIQUE_FLAGS.put(VERBOSE_FLAG, CommandLine.ArgFlag.VERBOSE);
        UNIQUE_FLAGS.put(PATH_FLAG, CommandLine.ArgFlag.PATH);
        UNIQUE_FLAGS.put(API_OUTPUT_FLAG, CommandLine.ArgFlag.API_OUTPUT);
        UNIQUE_FLAGS.put(STATECHANSUBTYPES_FLAG, CommandLine.ArgFlag.SCHAN_API_SUBTYPES);
        UNIQUE_FLAGS.put(OLD_WF_FLAG, CommandLine.ArgFlag.OLD_WF);
        UNIQUE_FLAGS.put(MIN_EFSM_FLAG, CommandLine.ArgFlag.MIN_EFSM);
        UNIQUE_FLAGS.put(FAIR_FLAG, CommandLine.ArgFlag.FAIR);
        UNIQUE_FLAGS.put(NO_LOCAL_CHOICE_SUBJECT_CHECK, CommandLine.ArgFlag.NO_LOCAL_CHOICE_SUBJECT_CHECK);
        UNIQUE_FLAGS.put(PROJECT_FLAG, CommandLine.ArgFlag.PROJECT);
        UNIQUE_FLAGS.put(FSM_FLAG, CommandLine.ArgFlag.FSM);
        UNIQUE_FLAGS.put(FSM_DOT_FLAG, CommandLine.ArgFlag.FSM_DOT);
        UNIQUE_FLAGS.put(CHECKED_FSM_FLAG, CommandLine.ArgFlag.CHECKED_FSM);
        UNIQUE_FLAGS.put(CHECKED_FSM_DOT_FLAG, CommandLine.ArgFlag.CHECKED_FSM_DOT);
        NON_UNIQUE_FLAGS.put(SESSION_FLAG, CommandLine.ArgFlag.SESS_API);
        NON_UNIQUE_FLAGS.put(STATECHAN_FLAG, CommandLine.ArgFlag.SCHAN_API);
        NON_UNIQUE_FLAGS.put(API_FLAG, CommandLine.ArgFlag.EP_API);
        NON_UNIQUE_FLAGS.put(GLOBAL_MODEL_FLAG, CommandLine.ArgFlag.GLOBAL_MODEL);
        NON_UNIQUE_FLAGS.put(GLOBAL_MODEL_DOT_FLAG, CommandLine.ArgFlag.GLOBAL_MODEL_DOT);
        NON_UNIQUE_FLAGS.put(NO_LIVENESS_FLAG, CommandLine.ArgFlag.NO_LIVENESS);
        FLAGS.putAll(UNIQUE_FLAGS);
        FLAGS.putAll(NON_UNIQUE_FLAGS);
        this.parsed = new HashMap<CommandLine.ArgFlag, String[]>();
        this.args = args;
        this.parseArgs();
    }

    public Map<CommandLine.ArgFlag, String[]> getArgs() {
        return this.parsed;
    }

    private void parseArgs() throws CommandLineException {
        int i = 0;
        while (i < this.args.length) {
            String arg = this.args[i];
            if (FLAGS.containsKey(arg)) {
                i = this.parseFlag(i);
            } else {
                if (this.parsed.containsKey((Object)CommandLine.ArgFlag.MAIN)) {
                    throw new CommandLineException("Duplicate main module arg: " + arg);
                }
                this.parseMain(i);
            }
            ++i;
        }
    }

    private int parseFlag(int i) throws CommandLineException {
        String flag;
        switch (flag = this.args[i]) {
            case "-junit": {
                this.parsed.put(CommandLine.ArgFlag.JUNIT, new String[0]);
                return i;
            }
            case "-V": {
                this.parsed.put(CommandLine.ArgFlag.VERBOSE, new String[0]);
                return i;
            }
            case "-ip": {
                return this.parsePath(i);
            }
            case "-project": {
                return this.parseProject(i);
            }
            case "-fsm": {
                return this.parseFsm(i);
            }
            case "-fsmdot": {
                return this.parseFsmDot(i);
            }
            case "-vfsm": {
                return this.parseWFFsm(i);
            }
            case "-vfsmdot": {
                return this.parseWFFsmDot(i);
            }
            case "-session": {
                return this.parseSession(i);
            }
            case "-schan": {
                return this.parseStateChannels(i);
            }
            case "-api": {
                return this.parseApi(i);
            }
            case "-d": {
                return this.parseOutput(i);
            }
            case "-subtypes": {
                this.parsed.put(FLAGS.get(STATECHANSUBTYPES_FLAG), new String[0]);
                return i;
            }
            case "-model": {
                return this.parseGlobalModel(i);
            }
            case "-modeldot": {
                return this.parseGlobalModelDot(i);
            }
            case "-oldwf": {
                this.parsed.put(FLAGS.get(OLD_WF_FLAG), new String[0]);
                return i;
            }
            case "-nolive": {
                this.parsed.put(FLAGS.get(NO_LIVENESS_FLAG), new String[0]);
                return i;
            }
            case "-minfsm": {
                this.parsed.put(CommandLine.ArgFlag.MIN_EFSM, new String[0]);
                return i;
            }
            case "-fair": {
                this.parsed.put(CommandLine.ArgFlag.FAIR, new String[0]);
                return i;
            }
            case "-nolocalchoicecheck": {
                this.parsed.put(CommandLine.ArgFlag.NO_LOCAL_CHOICE_SUBJECT_CHECK, new String[0]);
                return i;
            }
        }
        throw new RuntimeException("[TODO] Unknown flag: " + flag);
    }

    private void parseMain(int i) throws CommandLineException {
        String main = this.args[i];
        if (!CommandLineArgParser.validateModuleArg(main)) {
            throw new CommandLineException("Bad module arg: " + main);
        }
        this.parsed.put(CommandLine.ArgFlag.MAIN, new String[]{main});
    }

    private int parsePath(int i) throws CommandLineException {
        String path;
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing path argument");
        }
        if (!CommandLineArgParser.validatePaths(path = this.args[++i])) {
            throw new CommandLineException("Module path '" + path + "' is not valid\r\n");
        }
        this.parsed.put(FLAGS.get(PATH_FLAG), new String[]{path});
        return i;
    }

    private int parseProject(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(FLAGS.get(PROJECT_FLAG), proto, role);
        return i;
    }

    private int parseFsm(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(FLAGS.get(FSM_FLAG), proto, role);
        return i;
    }

    private int parseFsmDot(int i) throws CommandLineException {
        if (i + 3 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role/file arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        String png = this.args[++i];
        this.concatArgs(FLAGS.get(FSM_DOT_FLAG), proto, role, png);
        return i;
    }

    private int parseWFFsm(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(FLAGS.get(CHECKED_FSM_FLAG), proto, role);
        return i;
    }

    private int parseWFFsmDot(int i) throws CommandLineException {
        if (i + 3 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role/file arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        String png = this.args[++i];
        this.concatArgs(FLAGS.get(CHECKED_FSM_DOT_FLAG), proto, role, png);
        return i;
    }

    private int parseSession(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing protocol argument");
        }
        String proto = this.args[++i];
        this.concatArgs(FLAGS.get(SESSION_FLAG), proto);
        return i;
    }

    private int parseStateChannels(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(FLAGS.get(STATECHAN_FLAG), proto, role);
        return i;
    }

    private int parseApi(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(FLAGS.get(API_FLAG), proto, role);
        return i;
    }

    private int parseGlobalModel(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        this.concatArgs(FLAGS.get(GLOBAL_MODEL_FLAG), proto);
        return i;
    }

    private int parseGlobalModelDot(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role/file arguments");
        }
        String proto = this.args[++i];
        String png = this.args[++i];
        this.concatArgs(FLAGS.get(GLOBAL_MODEL_DOT_FLAG), proto, png);
        return i;
    }

    private int parseOutput(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing directory argument");
        }
        String dir = this.args[++i];
        this.parsed.put(FLAGS.get(API_OUTPUT_FLAG), new String[]{dir});
        return i;
    }

    private void concatArgs(CommandLine.ArgFlag flag, String ... toAdd) {
        String[] args = this.parsed.get((Object)flag);
        if (args == null) {
            args = Arrays.copyOf(toAdd, toAdd.length);
        } else {
            String[] tmp = new String[args.length + toAdd.length];
            System.arraycopy(args, 0, tmp, 0, args.length);
            System.arraycopy(toAdd, 0, tmp, args.length, toAdd.length);
            args = tmp;
        }
        this.parsed.put(flag, args);
    }

    private static boolean validateModuleArg(String arg) {
        return arg.chars().noneMatch(i -> !Character.isLetterOrDigit(i) && i != 46 && i != File.separatorChar && i != 58 && i != 45 && i != 95 && i != 47);
    }

    private static boolean validatePaths(String paths) {
        String[] stringArray = paths.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (!new File(path).isDirectory()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

