/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.main;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.scribble.ast.ImportDecl;
import org.scribble.ast.ImportModule;
import org.scribble.ast.Module;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.DirectoryResourceLocator;
import org.scribble.main.resource.InputStreamResource;
import org.scribble.main.resource.Resource;
import org.scribble.main.resource.ResourceLocator;
import org.scribble.parser.AntlrParser;
import org.scribble.parser.ScribModuleLoader;
import org.scribble.parser.ScribParser;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.util.Pair;
import org.scribble.util.ScribParserException;
import org.scribble.visit.Job;

public class MainContext {
    public final boolean debug;
    public final boolean useOldWF;
    public final boolean noLiveness;
    public final boolean minEfsm;
    public final boolean fair;
    public final boolean noLocalChoiceSubjectCheck;
    public final ModuleName main;
    private final AntlrParser antlrParser;
    private final ScribParser scribParser;
    private final ResourceLocator locator;
    private final ScribModuleLoader loader;
    private final Map<ModuleName, Pair<Resource, Module>> parsed = new HashMap<ModuleName, Pair<Resource, Module>>();

    public MainContext(boolean debug, ResourceLocator locator, Path mainpath, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck) throws ScribParserException, ScribbleException {
        this.debug = debug;
        this.useOldWF = useOldWF;
        this.noLiveness = noLiveness;
        this.minEfsm = minEfsm;
        this.fair = fair;
        this.noLocalChoiceSubjectCheck = noLocalChoiceSubjectCheck;
        this.antlrParser = new AntlrParser();
        this.scribParser = new ScribParser();
        this.locator = locator;
        this.loader = new ScribModuleLoader(this.locator, this.antlrParser, this.scribParser);
        Pair<Resource, Module> p = this.loadMainModule(mainpath);
        this.main = ((Module)p.right).getFullModuleName();
        this.loadAllModules(p);
    }

    public Map<ModuleName, Module> getParsedModules() {
        return this.parsed.entrySet().stream().collect(Collectors.toMap(e -> (ModuleName)e.getKey(), e -> (Module)((Pair)e.getValue()).right));
    }

    private Pair<Resource, Module> loadMainModule(Path mainpath) throws ScribParserException, ScribbleException {
        InputStreamResource res = DirectoryResourceLocator.getResourceByFullPath((Path)mainpath);
        Module mod = (Module)this.scribParser.parse(this.antlrParser.parseAntlrTree((Resource)res));
        this.checkMainModuleName(mainpath, mod);
        return new Pair((Object)res, (Object)mod);
    }

    private void checkMainModuleName(Path mainpath, Module main) throws ScribbleException {
        String path;
        String tmp = path.substring((path = mainpath.toString()).lastIndexOf(File.separator) == -1 ? 0 : path.lastIndexOf(File.separator) + 1, path.lastIndexOf(46));
        if (!tmp.equals(main.getFullModuleName().getSimpleName().toString())) {
            throw new ScribbleException("Simple module name at path " + path + " mismatch: " + main.getFullModuleName());
        }
    }

    private void loadAllModules(Pair<Resource, Module> module) throws ScribParserException, ScribbleException {
        this.parsed.put(((Module)module.right).getFullModuleName(), module);
        for (ImportDecl id : ((Module)module.right).getImportDecls()) {
            ModuleName modname;
            if (!id.isImportModule() || this.parsed.containsKey(modname = ((ImportModule)id).modname.toName())) continue;
            this.loadAllModules((Pair<Resource, Module>)this.loader.loadModule(modname));
        }
    }

    public Job newJob() {
        return new Job(this.debug, this.getParsedModules(), this.main, this.useOldWF, this.noLiveness, this.minEfsm, this.fair, this.noLocalChoiceSubjectCheck);
    }
}

