/*
 * Decompiled with CFR 0.152.
 */
package demo.betty16.lec1.httplong.message;

import demo.betty16.lec1.httplong.message.Body;
import demo.betty16.lec1.httplong.message.HttpLongMessage;
import demo.betty16.lec1.httplong.message.client.Accept;
import demo.betty16.lec1.httplong.message.client.AcceptEncoding;
import demo.betty16.lec1.httplong.message.client.AcceptLanguage;
import demo.betty16.lec1.httplong.message.client.Connection;
import demo.betty16.lec1.httplong.message.client.DoNotTrack;
import demo.betty16.lec1.httplong.message.client.Host;
import demo.betty16.lec1.httplong.message.client.RequestLine;
import demo.betty16.lec1.httplong.message.client.UserAgent;
import demo.betty16.lec1.httplong.message.server.AcceptRanges;
import demo.betty16.lec1.httplong.message.server.ContentLength;
import demo.betty16.lec1.httplong.message.server.ContentType;
import demo.betty16.lec1.httplong.message.server.Date;
import demo.betty16.lec1.httplong.message.server.ETag;
import demo.betty16.lec1.httplong.message.server.HttpVersion;
import demo.betty16.lec1.httplong.message.server.LastModified;
import demo.betty16.lec1.httplong.message.server.Server;
import demo.betty16.lec1.httplong.message.server.StrictTransportSecurity;
import demo.betty16.lec1.httplong.message.server.Vary;
import demo.betty16.lec1.httplong.message.server.Via;
import demo.betty16.lec1.httplong.message.server._200;
import demo.betty16.lec1.httplong.message.server._404;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.scribble.net.ScribMessage;
import org.scribble.net.ScribMessageFormatter;

public class HttpLongMessageFormatter
implements ScribMessageFormatter {
    public static final Charset cs = Charset.forName("UTF8");
    private int len = -1;

    @Override
    public byte[] toBytes(ScribMessage m) throws IOException {
        return ((HttpLongMessage)m).toBytes();
    }

    @Override
    public ScribMessage fromBytes(ByteBuffer bb) throws IOException, ClassNotFoundException {
        String line;
        block73: {
            bb.flip();
            int rem = bb.remaining();
            if (rem < 2) {
                bb.compact();
                return null;
            }
            int pos = bb.position();
            String front = new String(new byte[]{bb.get(pos), bb.get(pos + 1)}, cs);
            if (front.equals("\r\n")) {
                if (this.len == -1) {
                    return new Body("");
                }
                if (rem < this.len + 2) {
                    bb.compact();
                    return null;
                }
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.len) {
                    sb.append((char)bb.get());
                    ++i;
                }
                this.len = -1;
                return new Body(sb.toString());
            }
            if (rem < pos + 4) {
                bb.compact();
                return null;
            }
            int code = this.isStatusCode(front = String.valueOf(front) + new String(new byte[]{bb.get(pos + 2), bb.get(pos + 3)}, cs));
            if (code > -1) {
                String reason = HttpLongMessageFormatter.readLine(bb, pos + 4).trim();
                bb.compact();
                if (reason == null) {
                    return null;
                }
                switch (code) {
                    case 200: {
                        return new _200(reason);
                    }
                    case 404: {
                        return new _404(reason);
                    }
                }
                throw new RuntimeException("Unknown status code: " + code);
            }
            if (front.startsWith("GET")) {
                String reql = HttpLongMessageFormatter.readLine(bb, pos + 4).trim();
                bb.compact();
                if (reql == null) {
                    return null;
                }
                String target = reql.substring(0, reql.indexOf(32));
                String vers = reql.substring(reql.indexOf(32) + 1).trim();
                vers = vers.substring(vers.indexOf(47) + 1);
                return new RequestLine(target, vers);
            }
            if (front.equals("HTTP")) {
                if (rem < pos + 5) {
                    bb.compact();
                    return null;
                }
                String word = HttpLongMessageFormatter.readWord(bb, pos + 5);
                bb.compact();
                if (word == null) {
                    return null;
                }
                return new HttpVersion(word);
            }
            line = HttpLongMessageFormatter.readLine(bb, pos + 4);
            bb.compact();
            if (line == null) {
                return null;
            }
            line = String.valueOf(front) + line;
            int colon = line.indexOf(58);
            if (colon <= -1) break block73;
            String name = line.substring(0, colon);
            String value = line.substring(colon + 1).trim();
            switch (name) {
                case "Host": {
                    return new Host("value");
                }
                case "User-Agent": {
                    return new UserAgent(value);
                }
                case "Accept": {
                    return new Accept(value);
                }
                case "Accept-Language": {
                    return new AcceptLanguage(value);
                }
                case "Accept-Encoding": {
                    return new AcceptEncoding(value);
                }
                case "DNT": {
                    return new DoNotTrack(Integer.parseInt(value));
                }
                case "Connection": {
                    return new Connection(value);
                }
                case "Date": {
                    return new Date(value);
                }
                case "Server": {
                    return new Server(value);
                }
                case "Strict-Transport-Security": {
                    return new StrictTransportSecurity(value);
                }
                case "Last-Modified": {
                    return new LastModified(value);
                }
                case "ETag": {
                    return new ETag(value);
                }
                case "Accept-Ranges": {
                    return new AcceptRanges(value);
                }
                case "Content-Length": {
                    this.len = Integer.parseInt(value.trim());
                    return new ContentLength(this.len);
                }
                case "Vary": {
                    return new Vary(value);
                }
                case "Content-Type": {
                    return new ContentType(value);
                }
                case "Via": {
                    return new Via(value);
                }
            }
            throw new RuntimeException("Cannot parse header field: " + line);
        }
        throw new RuntimeException("Cannot parse message: " + line);
    }

    private static String readLine(ByteBuffer bb, int i) throws IOException {
        StringBuilder sb = new StringBuilder();
        int limit = bb.limit();
        while (i <= limit) {
            char c = (char)bb.get(i++);
            sb.append(c);
            if (c != '\r') continue;
            if (i > limit) {
                return null;
            }
            c = (char)bb.get(i++);
            sb.append(c);
            if (c != '\n') continue;
            bb.position(i);
            return sb.substring(0, sb.length() - 2).toString();
        }
        return null;
    }

    private static String readWord(ByteBuffer bb, int i) throws IOException {
        StringBuilder sb = new StringBuilder();
        int limit = bb.limit();
        while (i <= limit) {
            char c;
            if ((c = (char)bb.get(i++)) == ' ') {
                bb.position(i);
                return sb.toString();
            }
            sb.append(c);
        }
        return null;
    }

    private int isStatusCode(String front) {
        String code = "";
        int i = 0;
        while (i < 4) {
            char c = front.charAt(i);
            if (i < 3) {
                if (c < '0' || c > '9') {
                    return -1;
                }
                code = String.valueOf(code) + c;
            } else if (c != ' ') {
                return -1;
            }
            ++i;
        }
        return Integer.parseInt(code);
    }

    @Override
    @Deprecated
    public void writeMessage(DataOutputStream dos, ScribMessage m) throws IOException {
        dos.write(((HttpLongMessage)m).toBytes());
        dos.flush();
    }

    @Override
    @Deprecated
    public ScribMessage readMessage(DataInputStream dis) throws IOException {
        String line;
        block62: {
            byte[] bs = new byte[2];
            dis.readFully(bs);
            String front = new String(bs, cs);
            if (front.equals("\r\n")) {
                if (this.len == -1) {
                    return new Body("");
                }
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.len) {
                    sb.append((char)dis.read());
                    ++i;
                }
                this.len = -1;
                return new Body(sb.toString());
            }
            bs = new byte[2];
            dis.readFully(bs);
            front = String.valueOf(front) + new String(bs, cs);
            int code = this.isStatusCode(front);
            if (code > -1) {
                String reason = HttpLongMessageFormatter.readLine(dis).trim();
                switch (code) {
                    case 200: {
                        return new _200(reason);
                    }
                    case 404: {
                        return new _404(reason);
                    }
                }
                throw new RuntimeException("Unknown status code: " + code);
            }
            if (front.startsWith("GET")) {
                String reql = HttpLongMessageFormatter.readLine(dis).trim();
                String target = reql.substring(0, reql.indexOf(32));
                String vers = reql.substring(reql.indexOf(32) + 1).trim();
                vers = vers.substring(vers.indexOf(47) + 1);
                return new RequestLine(target, vers);
            }
            if (front.equals("HTTP")) {
                dis.read();
                String word = HttpLongMessageFormatter.readWord(dis);
                return new HttpVersion(word);
            }
            line = String.valueOf(front) + HttpLongMessageFormatter.readLine(dis);
            int colon = line.indexOf(58);
            if (colon <= -1) break block62;
            String name = line.substring(0, colon);
            String value = line.substring(colon + 1).trim();
            switch (name) {
                case "Host": {
                    return new Host("value");
                }
                case "User-Agent": {
                    return new UserAgent(value);
                }
                case "Accept": {
                    return new Accept(value);
                }
                case "Accept-Language": {
                    return new AcceptLanguage(value);
                }
                case "Accept-Encoding": {
                    return new AcceptEncoding(value);
                }
                case "DNT": {
                    return new DoNotTrack(Integer.parseInt(value));
                }
                case "Connection": {
                    return new Connection(value);
                }
                case "Date": {
                    return new Date(value);
                }
                case "Server": {
                    return new Server(value);
                }
                case "Last-Modified": {
                    return new LastModified(value);
                }
                case "ETag": {
                    return new ETag(value);
                }
                case "Accept-Ranges": {
                    return new AcceptRanges(value);
                }
                case "Content-Length": {
                    this.len = Integer.parseInt(value.trim());
                    return new ContentLength(this.len);
                }
                case "Vary": {
                    return new Vary(value);
                }
                case "Content-Type": {
                    return new ContentType(value);
                }
                case "Via": {
                    return new Via(value);
                }
            }
            throw new RuntimeException("Cannot parse header field: " + line);
        }
        throw new RuntimeException("Cannot parse message: " + line);
    }

    private static String readLine(DataInputStream dis) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c = (char)dis.read();
            sb.append(c);
            if (c != '\r') continue;
            c = (char)dis.read();
            sb.append(c);
            if (c == '\n') break;
        }
        return sb.substring(0, sb.length() - 2).toString();
    }

    private static String readWord(DataInputStream dis) throws IOException {
        StringBuilder sb = new StringBuilder();
        char c;
        while ((c = (char)dis.read()) != ' ') {
            sb.append(c);
        }
        return sb.toString();
    }
}

