/*
 * Decompiled with CFR 0.152.
 */
package demo.betty16.lec1.httpshort.message;

import demo.betty16.lec1.httpshort.message.HttpShortMessage;
import demo.betty16.lec1.httpshort.message.client.Request;
import demo.betty16.lec1.httpshort.message.server.Response;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.scribble.net.ScribMessage;
import org.scribble.net.ScribMessageFormatter;

public class HttpShortMessageFormatter
implements ScribMessageFormatter {
    public static final Charset cs = Charset.forName("UTF8");

    @Override
    public byte[] toBytes(ScribMessage m) throws IOException {
        return ((HttpShortMessage)m).toBytes();
    }

    @Override
    public ScribMessage fromBytes(ByteBuffer bb) throws IOException, ClassNotFoundException {
        String endOfHeaders;
        bb.flip();
        int rem = bb.remaining();
        if (rem < 2) {
            bb.compact();
            return null;
        }
        String curr = new String(Arrays.copyOf(bb.array(), bb.remaining()), cs);
        if (!curr.contains(endOfHeaders = "\r\n\r\n")) {
            bb.compact();
            return null;
        }
        if (curr.contains("Content-Length")) {
            int eoh = curr.indexOf(endOfHeaders);
            if (eoh == -1) {
                bb.compact();
                return null;
            }
            String contentLenSplit = curr.substring(curr.indexOf("Content-Length"));
            int len = Integer.parseInt(contentLenSplit.substring("Content-Length".length() + 2, contentLenSplit.indexOf(13)).trim());
            if (curr.length() < eoh + 4) {
                bb.compact();
                return null;
            }
            String body = curr.substring(eoh + 4);
            if (body.getBytes(cs).length < len) {
                bb.compact();
                return null;
            }
            byte[] bs = new byte[bb.remaining()];
            bb.get(bs);
            bb.compact();
            return HttpShortMessageFormatter.parseResponse(new String(bs, cs));
        }
        byte[] bs = new byte[bb.remaining()];
        bb.get(bs);
        bb.compact();
        return HttpShortMessageFormatter.parseRequest(new String(bs, cs));
    }

    private static HttpShortMessage parseRequest(String msg) {
        String get = null;
        String http = null;
        String host = null;
        String userA = null;
        String accept = null;
        String acceptL = null;
        String acceptE = null;
        String dnt = null;
        String connection = null;
        boolean eoh = false;
        while (!eoh) {
            if (msg.startsWith("\r\n")) {
                eoh = true;
                msg = msg.substring(2);
                break;
            }
            int i = (msg = msg.replace("\\A\\s+", "")).indexOf(":");
            if (i == -1) {
                throw new RuntimeException("Shouldn't get in here: " + msg);
            }
            if (msg.startsWith("GET")) {
                int j = msg.indexOf(32);
                get = msg.substring(j + 1, msg.indexOf(32, j + 1)).trim();
                j = msg.indexOf(13);
                http = msg.substring(msg.indexOf(47) + 1, j).trim();
                msg = msg.substring(j + 2);
                continue;
            }
            String header = msg.substring(0, i);
            int j = msg.indexOf("\r");
            switch (header) {
                case "Host": {
                    host = msg.substring(i + 1, j).trim();
                    break;
                }
                case "User-Agent": {
                    userA = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Accept": {
                    accept = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Accept-Language": {
                    acceptL = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Accept-Encoding": {
                    acceptE = msg.substring(i + 1, j).trim();
                    break;
                }
                case "DNT": {
                    dnt = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Connection": {
                    connection = msg.substring(i + 1, j).trim();
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot parse header field: " + msg.substring(0, j));
                }
            }
            msg = msg.substring(j + 2);
        }
        if (!msg.isEmpty()) {
            throw new RuntimeException("Shouldn't get in here: " + msg);
        }
        return new Request(get, http, host, userA, accept, acceptL, acceptE, dnt, connection);
    }

    private static HttpShortMessage parseResponse(String msg) {
        String httpv = null;
        String ack = null;
        String date = null;
        String server = null;
        String strictTS = null;
        String lastMod = null;
        String eTag = null;
        String acceptR = null;
        String contentL = null;
        String vary = null;
        String contentT = null;
        String via = null;
        String body = null;
        boolean eoh = false;
        while (!eoh) {
            if (msg.startsWith("\r\n")) {
                eoh = true;
                msg = msg.substring(2);
                break;
            }
            int i = (msg = msg.trim()).indexOf(":");
            if (i == -1) {
                throw new RuntimeException("Shouldn't get in here: " + msg);
            }
            if (msg.startsWith("HTTP")) {
                int j = msg.indexOf(32);
                httpv = msg.substring(msg.indexOf(47) + 1, j);
                int k = msg.indexOf(13);
                ack = msg.substring(j + 1, k);
                msg = msg.substring(k + 2);
                continue;
            }
            String header = msg.substring(0, i);
            int j = msg.indexOf("\r");
            switch (header) {
                case "Date": {
                    date = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Server": {
                    server = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Strict-Transport-Security": {
                    strictTS = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Last-Modified": {
                    lastMod = msg.substring(i + 1, j).trim();
                    break;
                }
                case "ETag": {
                    eTag = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Accept-Ranges": {
                    acceptR = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Content-Length": {
                    contentL = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Vary": {
                    vary = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Content-Type": {
                    contentT = msg.substring(i + 1, j).trim();
                    break;
                }
                case "Via": {
                    via = msg.substring(i + 1, j).trim();
                    break;
                }
                default: {
                    System.err.println("[Warning] Attempting to skip over response field: " + header + "\n" + msg.substring(i + 1, j).trim());
                }
            }
            msg = msg.substring(j + 2);
        }
        body = msg;
        return new Response(httpv, ack, date, server, strictTS, lastMod, eTag, acceptR, contentL, vary, contentT, via, body);
    }

    @Override
    @Deprecated
    public void writeMessage(DataOutputStream dos, ScribMessage m) throws IOException {
        throw new RuntimeException("Shouldn't get in here: " + m);
    }

    @Override
    @Deprecated
    public ScribMessage readMessage(DataInputStream dis) throws IOException {
        throw new RuntimeException("Shouldn't get in here: ");
    }
}

