/*
 * Decompiled with CFR 0.152.
 */
package demo.http.longvers.message;

import demo.http.longvers.HttpLong.Http.Http;
import demo.http.longvers.message.HttpLongMessageFormatter;
import org.scribble.net.ScribMessage;
import org.scribble.sesstype.name.Op;

public abstract class HttpLongMessage
extends ScribMessage {
    private static final long serialVersionUID = 1L;
    public static final String GET = "GET";
    public static final String HTTP = "HTTP";
    public static final String HOST = "Host";
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String DO_NOT_TRACK = "DNT";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String _404 = "404";
    public static final String _200 = "200";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String VARY = "Vary";
    public static final String SERVER = "Server";
    public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    public static final String VIA = "Via";
    public static final String ETAG = "ETag";
    public static final String CONTENT_LENGTH = "Content-Length";
    protected static final String CRLF = "\r\n";

    public HttpLongMessage(Op op) {
        super(op, new Object[0]);
    }

    public HttpLongMessage(Op op, String body) {
        super(op, body);
    }

    public String getBody() {
        return this.payload.length == 0 ? "" : (String)this.payload[0];
    }

    public byte[] toBytes() {
        return (String.valueOf(HttpLongMessage.getOpString(this.op)) + this.getBody() + CRLF).getBytes(HttpLongMessageFormatter.cs);
    }

    @Override
    public String toString() {
        return new String(this.toBytes());
    }

    protected static String getOpString(Op op) {
        if (op.equals(Http.CONTENTL)) {
            return CONTENT_LENGTH;
        }
        if (op.equals(Http.ETAG)) {
            return ETAG;
        }
        if (op.equals(Http.BODY)) {
            return CRLF;
        }
        if (op.equals(Http.VIA)) {
            return VIA;
        }
        if (op.equals(Http.SERVER)) {
            return SERVER;
        }
        if (op.equals(Http.VARY)) {
            return VARY;
        }
        if (op.equals(CRLF)) {
            return "";
        }
        if (op.equals(Http.REQUESTL)) {
            return GET;
        }
        if (op.equals(Http.LASTM)) {
            return LAST_MODIFIED;
        }
        if (op.equals(Http.ACCEPTR)) {
            return ACCEPT_RANGES;
        }
        if (op.equals(Http.HOST)) {
            return HOST;
        }
        if (op.equals(Http.HTTPV)) {
            return HTTP;
        }
        if (op.equals(Http._200)) {
            return _200;
        }
        if (op.equals(Http._404)) {
            return _404;
        }
        if (op.equals(Http.CONTENTT)) {
            return CONTENT_TYPE;
        }
        if (op.equals(Http.DATE)) {
            return DATE;
        }
        throw new RuntimeException("TODO: " + op);
    }
}

