/*
 * Decompiled with CFR 0.152.
 */
package demo.smtp;

import demo.smtp.EraserThread;
import demo.smtp.Smtp.Smtp.Smtp;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_1;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_10;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_11_Cases;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_12;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_2;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_3;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_3_Cases;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_4;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_6;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_7;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_7_Cases;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_8;
import demo.smtp.Smtp.Smtp.channels.C.Smtp_C_9_Cases;
import demo.smtp.Smtp.Smtp.channels.C.ioifaces.Succ_In_S_220;
import demo.smtp.Smtp.Smtp.roles.C;
import demo.smtp.message.SmtpMessageFormatter;
import demo.smtp.message.client.Auth;
import demo.smtp.message.client.Data;
import demo.smtp.message.client.DataLine;
import demo.smtp.message.client.Ehlo;
import demo.smtp.message.client.EndOfData;
import demo.smtp.message.client.Mail;
import demo.smtp.message.client.Quit;
import demo.smtp.message.client.Rcpt;
import demo.smtp.message.client.StartTls;
import demo.smtp.message.client.Subject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Base64;
import org.scribble.net.Buf;
import org.scribble.net.scribsock.LinearSocket;
import org.scribble.net.session.SSLSocketChannelWrapper;
import org.scribble.net.session.SessionEndpoint;
import org.scribble.net.session.SocketChannelEndpoint;

public class SmtpClient {
    public SmtpClient() throws Exception {
        this.run();
    }

    public static void main(String[] args) throws Exception {
        new SmtpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws Exception {
        String host = "smtp.cc.ic.ac.uk";
        int port = 25;
        Smtp smtp = new Smtp();
        Throwable throwable = null;
        Object var5_6 = null;
        try (SessionEndpoint<Smtp, C> se = new SessionEndpoint<Smtp, C>(smtp, Smtp.C, new SmtpMessageFormatter());){
            se.connect(Smtp.S, SocketChannelEndpoint::new, host, port);
            Smtp_C_1 s1 = new Smtp_C_1(se);
            Succ_In_S_220 s2 = s1.receive(Smtp.S, Smtp._220, new Buf());
            Smtp_C_10 s10 = this.doAuth(this.doSecureEhlo(this.doStartTls(this.doEhlo((Smtp_C_2)s2))));
            Smtp_C_11_Cases s11cases = s10.send(Smtp.S, new Mail("rhu@doc.ic.ac.uk")).branch(Smtp.S);
            switch (s11cases.op) {
                case _250: {
                    this.sendMail(s11cases.receive(Smtp._250));
                    return;
                }
                case _501: {
                    s11cases.receive(Smtp._501).send(Smtp.S, new Quit());
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private Smtp_C_4 doEhlo(Smtp_C_2 s2) throws Exception {
        Smtp_C_3 s3 = s2.send(Smtp.S, new Ehlo("testing1"));
        Buf b = new Buf();
        while (true) {
            Smtp_C_3_Cases s3cases = s3.branch(Smtp.S);
            switch (s3cases.op) {
                case _250: {
                    Smtp_C_4 s4 = s3cases.receive(Smtp._250, b);
                    System.out.print("Ehlo: " + b.val);
                    return s4;
                }
                case _250d: {
                    s3 = s3cases.receive(Smtp._250d, b);
                    System.out.print("Ehlo: " + b.val);
                }
            }
        }
    }

    private Smtp_C_6 doStartTls(Smtp_C_4 s4) throws Exception {
        Buf b = new Buf();
        Succ_In_S_220 s6 = s4.send(Smtp.S, new StartTls()).receive(Smtp.S, Smtp._220, b);
        System.out.print("StartTLS: " + b.val);
        ((LinearSocket)((Object)s6)).wrapClient(Smtp.S, SSLSocketChannelWrapper::new);
        return s6;
    }

    private Smtp_C_8 doSecureEhlo(Smtp_C_6 s6) throws Exception {
        Smtp_C_7 s7 = s6.send(Smtp.S, new Ehlo("testing2"));
        Buf b = new Buf();
        while (true) {
            Smtp_C_7_Cases s7cases = s7.branch(Smtp.S);
            switch (s7cases.op) {
                case _250: {
                    Smtp_C_8 s8 = s7cases.receive(Smtp._250, b);
                    System.out.print("Ehlo: " + b.val);
                    return s8;
                }
                case _250d: {
                    s7 = s7cases.receive(Smtp._250d, b);
                    System.out.print("Ehlo: " + b.val);
                }
            }
        }
    }

    private Smtp_C_10 doAuth(Smtp_C_8 s8) throws Exception {
        Smtp_C_9_Cases s9cases = s8.send(Smtp.S, new Auth(SmtpClient.getAuthPlain())).branch(Smtp.S);
        Buf b = new Buf();
        switch (s9cases.op) {
            case _235: {
                Smtp_C_10 s10 = s9cases.receive(Smtp._235, b);
                System.out.print("Auth: " + b.val);
                return s10;
            }
            case _535: {
                s9cases.receive(Smtp._535, b).send(Smtp.S, new Quit());
                System.out.print("Auth: " + b.val);
                System.exit(0);
            }
        }
        throw new RuntimeException("Shouldn't get in here: " + s9cases.op);
    }

    private void sendMail(Smtp_C_12 s12) throws Exception {
        ((Smtp_C_10)s12.send(Smtp.S, new Rcpt("rhu@doc.ic.ac.uk")).async(Smtp.S, Smtp._250).send(Smtp.S, new Data()).async(Smtp.S, Smtp._354).send(Smtp.S, new Subject("hello Manchester")).send(Smtp.S, new DataLine("message body")).send(Smtp.S, new EndOfData()).receive(Smtp.S, Smtp._250, new Buf())).send(Smtp.S, new Quit());
    }

    protected static String getAuthPlain() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("User: ");
        String user = br.readLine();
        System.out.println("Password: ");
        EraserThread et = new EraserThread();
        et.start();
        String pw = br.readLine();
        et.stopMasking();
        byte[] u = user.getBytes("utf-8");
        byte[] p = pw.getBytes("utf-8");
        byte[] bs = new byte[u.length + p.length + 2];
        System.arraycopy(u, 0, bs, 1, u.length);
        System.arraycopy(p, 0, bs, u.length + 2, p.length);
        return Base64.getEncoder().encodeToString(bs);
    }
}

