/*
 * Decompiled with CFR 0.152.
 */
package demo.smtp.message;

import demo.smtp.Smtp.Smtp.Smtp;
import demo.smtp.message.SmtpMessageFormatter;
import org.scribble.net.ScribMessage;
import org.scribble.sesstype.name.Op;
import org.scribble.util.Caller;

public abstract class SmtpMessage
extends ScribMessage {
    public static final String _220 = "220";
    public static final String _250 = "250";
    public static final String _250_ = "250-";
    public static final String _235 = "235";
    public static final String _535 = "535";
    public static final String _501 = "501";
    public static final String _354 = "354";
    public static final String EHLO = "ehlo";
    public static final String STARTTLS = "starttls";
    public static final String AUTH = "auth plain";
    public static final String MAIL = "mail from:";
    public static final String RCPT = "rcpt to:";
    public static final String SUBJECT = "subject:";
    public static final String DATA = "data";
    public static final String QUIT = "quit";
    public static final String DATA_LINE = "";
    public static final String END_OF_DATA = "";
    private static final long serialVersionUID = 1L;
    protected static final String CRLF = "\r\n";

    public SmtpMessage(Op op) {
        super(op, new Object[0]);
    }

    public SmtpMessage(Op op, String body) {
        super(op, body);
    }

    public String getBody() {
        return this.payload.length == 0 ? "" : (String)this.payload[0];
    }

    public byte[] toBytes() {
        byte[] bs = (String.valueOf(SmtpMessage.getOpString(this.op)) + " " + this.getBody() + CRLF).getBytes(SmtpMessageFormatter.cs);
        return bs;
    }

    @Override
    public String toString() {
        return new String(this.toBytes());
    }

    protected static String getOpString(Op op) {
        return op.equals(Smtp._220) ? _220 : (op.equals(Smtp._250) ? _250 : (op.equals(Smtp._250d) ? _250_ : (op.equals(Smtp._235) ? _235 : (op.equals(Smtp._535) ? _535 : (op.equals(Smtp._501) ? _501 : (op.equals(Smtp._354) ? _354 : (op.equals(Smtp.Ehlo) ? EHLO : (op.equals(Smtp.StartTls) ? STARTTLS : (op.equals(Smtp.Auth) ? AUTH : (op.equals(Smtp.Mail) ? MAIL : (op.equals(Smtp.Rcpt) ? RCPT : (op.equals(Smtp.Subject) ? SUBJECT : (op.equals(Smtp.Data) ? DATA : (op.equals(Smtp.Quit) ? QUIT : (op.equals(Smtp.DataLine) ? "" : (op.equals(Smtp.EndOfData) ? "" : new Caller().call(() -> {
            throw new RuntimeException("TODO: " + op);
        })))))))))))))))));
    }
}

