/*
 * Decompiled with CFR 0.152.
 */
package demo.smtp.message;

import demo.smtp.message.SmtpMessage;
import demo.smtp.message.server._220;
import demo.smtp.message.server._235;
import demo.smtp.message.server._250;
import demo.smtp.message.server._250d;
import demo.smtp.message.server._354;
import demo.smtp.message.server._501;
import demo.smtp.message.server._535;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.scribble.net.ScribMessage;
import org.scribble.net.ScribMessageFormatter;

public class SmtpMessageFormatter
implements ScribMessageFormatter {
    public static Charset cs = Charset.forName("UTF8");

    @Override
    public byte[] toBytes(ScribMessage m) throws IOException {
        return ((SmtpMessage)m).toBytes();
    }

    @Override
    public ScribMessage fromBytes(ByteBuffer bb) throws IOException, ClassNotFoundException {
        bb.flip();
        int rem = bb.remaining();
        if (rem < 2) {
            bb.compact();
            return null;
        }
        int pos = bb.position();
        String front = new String(new byte[]{bb.get(pos), bb.get(pos + 1)}, cs);
        if (front.equals("\r\n")) {
            throw new RuntimeException("TODO: ");
        }
        if (rem < pos + 4) {
            bb.compact();
            return null;
        }
        int code = this.isStatusCode(front = String.valueOf(front) + new String(new byte[]{bb.get(pos + 2), bb.get(pos + 3)}, cs));
        if (code > -1) {
            String body = SmtpMessageFormatter.readLine(bb, pos + 4).trim();
            bb.compact();
            if (body == null) {
                return null;
            }
            switch (code) {
                case 220: {
                    return new _220(body);
                }
                case 250: {
                    if (front.charAt(3) == '-') {
                        return new _250d(body);
                    }
                    return new _250(body);
                }
                case 235: {
                    return new _235(body);
                }
                case 535: {
                    return new _535(body);
                }
                case 501: {
                    return new _501(body);
                }
                case 354: {
                    return new _354(body);
                }
            }
            throw new RuntimeException("Unknown status code " + code + ": " + body);
        }
        String line = String.valueOf(front) + SmtpMessageFormatter.readLine(bb, pos + 4);
        bb.compact();
        throw new RuntimeException("Cannot parse message: " + line);
    }

    private static String readLine(ByteBuffer bb, int i) throws IOException {
        StringBuilder sb = new StringBuilder();
        int limit = bb.limit();
        while (i <= limit) {
            char c = (char)bb.get(i++);
            sb.append(c);
            if (c != '\r') continue;
            c = (char)bb.get(i++);
            sb.append(c);
            if (c != '\n') continue;
            bb.position(i);
            return sb.substring(0, sb.length() - 2).toString();
        }
        return null;
    }

    private int isStatusCode(String front) {
        String code = "";
        int i = 0;
        while (i < 4) {
            char c = front.charAt(i);
            if (i < 3) {
                if (c < '0' || c > '9') {
                    return -1;
                }
                code = String.valueOf(code) + c;
            } else if (c != ' ' && c != '-') {
                return -1;
            }
            ++i;
        }
        return Integer.parseInt(code);
    }

    @Override
    public void writeMessage(DataOutputStream dos, ScribMessage m) throws IOException {
        dos.write(((SmtpMessage)m).toBytes());
        dos.flush();
    }

    @Override
    public SmtpMessage readMessage(DataInputStream dis) throws IOException {
        byte[] bs = new byte[2];
        dis.readFully(bs);
        String front = new String(bs, cs);
        if (front.equals("\r\n")) {
            throw new RuntimeException("TODO: ");
        }
        bs = new byte[2];
        dis.readFully(bs);
        front = String.valueOf(front) + new String(bs, cs);
        int code = this.isStatusCode(front);
        if (code > -1) {
            String body = SmtpMessageFormatter.readLine(dis).trim();
            switch (code) {
                case 220: {
                    return new _220(body);
                }
                case 250: {
                    if (front.charAt(3) == '-') {
                        return new _250d(body);
                    }
                    return new _250(body);
                }
                case 235: {
                    return new _235(body);
                }
                case 535: {
                    return new _535(body);
                }
                case 501: {
                    return new _501(body);
                }
                case 354: {
                    return new _354(body);
                }
            }
            throw new RuntimeException("Unknown status code: " + code);
        }
        String line = String.valueOf(front) + SmtpMessageFormatter.readLine(dis);
        throw new RuntimeException("Cannot parse message: " + line);
    }

    private static String readLine(DataInputStream dis) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c = (char)dis.read();
            sb.append(c);
            if (c != '\r') continue;
            c = (char)dis.read();
            sb.append(c);
            if (c == '\n') break;
        }
        return sb.substring(0, sb.length() - 2).toString();
    }
}

