/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.scribble.ast.CompoundInteractionNode;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.visit.AstVisitor;

public abstract class Choice<K extends ProtocolKind>
extends CompoundInteractionNode<K> {
    public final RoleNode subj;
    private final List<? extends ProtocolBlock<K>> blocks;

    protected Choice(RoleNode subj, List<? extends ProtocolBlock<K>> blocks) {
        this.subj = subj;
        this.blocks = new LinkedList<ProtocolBlock<K>>(blocks);
    }

    public abstract Choice<K> reconstruct(RoleNode var1, List<? extends ProtocolBlock<K>> var2);

    @Override
    public Choice<K> visitChildren(AstVisitor nv) throws ScribbleException {
        RoleNode subj = (RoleNode)this.visitChild(this.subj, nv);
        List<? extends ProtocolBlock<K>> blocks = Choice.visitChildListWithClassEqualityCheck(this, this.blocks, nv);
        return this.reconstruct(subj, blocks);
    }

    public List<? extends ProtocolBlock<K>> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public String toString() {
        String sep = " or ";
        return "choice at " + this.subj + " " + this.blocks.stream().map(b -> b.toString()).collect(Collectors.joining(sep));
    }
}

