/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.scribble.ast.InteractionNode;
import org.scribble.ast.ProtocolKindNode;
import org.scribble.ast.ScribNode;
import org.scribble.ast.ScribNodeBase;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.visit.AstVisitor;

public abstract class InteractionSeq<K extends ProtocolKind>
extends ScribNodeBase
implements ProtocolKindNode<K> {
    private final List<? extends InteractionNode<K>> inters;

    protected InteractionSeq(List<? extends InteractionNode<K>> inters) {
        this.inters = inters;
    }

    public abstract InteractionSeq<K> reconstruct(List<? extends InteractionNode<K>> var1);

    @Override
    public ScribNode visitChildren(AstVisitor nv) throws ScribbleException {
        LinkedList<ProtocolKindNode<K>> actions = new LinkedList<ProtocolKindNode<K>>();
        for (InteractionNode<K> in : this.inters) {
            ProtocolKindNode<K> tmp;
            ScribNode visited = this.visitChild(in, nv);
            if (visited instanceof InteractionSeq) {
                tmp = (InteractionSeq)visited;
                actions.addAll(tmp.inters);
                continue;
            }
            tmp = (InteractionNode)visited;
            actions.add(tmp);
        }
        return this.reconstruct(actions);
    }

    public List<? extends InteractionNode<K>> getInteractions() {
        return Collections.unmodifiableList(this.inters);
    }

    public boolean isEmpty() {
        return this.inters.isEmpty();
    }

    public String toString() {
        return this.inters.stream().map(i -> i.toString()).collect(Collectors.joining("\n"));
    }
}

