/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.List;
import java.util.stream.Collectors;
import org.scribble.ast.CompoundInteractionNode;
import org.scribble.ast.Interrupt;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.ScopedNode;
import org.scribble.ast.name.simple.ScopeNode;
import org.scribble.sesstype.kind.ProtocolKind;

public abstract class Interruptible<K extends ProtocolKind>
extends CompoundInteractionNode<K>
implements ScopedNode {
    public final ScopeNode scope;
    public final ProtocolBlock<K> block;
    private final List<? extends Interrupt> interrs;

    protected Interruptible(ScopeNode scope, ProtocolBlock<K> block, List<? extends Interrupt> interrs) {
        this.scope = scope;
        this.block = block;
        this.interrs = interrs;
    }

    public boolean isScopeNodeImplicit() {
        return this.scope == null;
    }

    public String toString() {
        String s = "interruptible ";
        if (!this.isScopeNodeImplicit()) {
            s = String.valueOf(s) + this.scope + ": ";
        }
        s = String.valueOf(s) + this.block + " " + "with" + " {\n";
        s = String.valueOf(s) + this.interrs.stream().map(i -> i.toString()).collect(Collectors.joining("\n")) + "\n";
        return String.valueOf(s) + "}";
    }
}

