/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.ImportDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.ModuleDecl;
import org.scribble.ast.NonProtocolDecl;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNodeBase;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.ast.local.LProtocolDecl;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.AbstractName;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.util.ScribUtil;
import org.scribble.visit.AstVisitor;

public class Module
extends ScribNodeBase {
    public final ModuleDecl moddecl;
    private final List<ImportDecl<?>> imports;
    private final List<NonProtocolDecl<?>> data;
    private final List<ProtocolDecl<?>> protos;
    private static final Predicate<ProtocolDecl<?>> IS_GLOBALPROTOCOLDECL = pd -> pd.isGlobal();
    private static final Predicate<ProtocolDecl<?>> IS_LOCALPROTOCOLDECL = pd -> pd.isLocal();
    private static final Function<ProtocolDecl<?>, GProtocolDecl> TO_GLOBALPROTOCOLDECL = pd -> (GProtocolDecl)pd;
    private static final Function<ProtocolDecl<?>, LProtocolDecl> TO_LOCALPROTOCOLDECL = pd -> (LProtocolDecl)pd;

    public Module(ModuleDecl moddecl, List<ImportDecl<?>> imports, List<NonProtocolDecl<?>> data, List<ProtocolDecl<?>> protos) {
        this.moddecl = moddecl;
        this.imports = new LinkedList(imports);
        this.data = new LinkedList(data);
        this.protos = new LinkedList(protos);
    }

    @Override
    protected Module copy() {
        return new Module(this.moddecl, this.imports, this.data, this.protos);
    }

    @Override
    public Module clone() {
        ModuleDecl moddecl = this.moddecl.clone();
        List<ImportDecl<?>> imports = ScribUtil.cloneList(this.imports);
        List<NonProtocolDecl<?>> data = ScribUtil.cloneList(this.data);
        List<ProtocolDecl<?>> protos = ScribUtil.cloneList(this.protos);
        return AstFactoryImpl.FACTORY.Module(moddecl, imports, data, protos);
    }

    public Module reconstruct(ModuleDecl moddecl, List<ImportDecl<?>> imports, List<NonProtocolDecl<?>> data, List<ProtocolDecl<?>> protos) {
        ScribDel del = this.del();
        Module m = new Module(moddecl, imports, data, protos);
        m = (Module)m.del(del);
        return m;
    }

    @Override
    public Module visitChildren(AstVisitor nv) throws ScribbleException {
        ModuleDecl moddecl = (ModuleDecl)this.visitChild(this.moddecl, nv);
        List<ImportDecl<?>> imports = ScribNodeBase.visitChildListWithClassEqualityCheck(this, this.imports, nv);
        List<NonProtocolDecl<?>> data = ScribNodeBase.visitChildListWithClassEqualityCheck(this, this.data, nv);
        List<ProtocolDecl<?>> protos = ScribNodeBase.visitChildListWithClassEqualityCheck(this, this.protos, nv);
        return this.reconstruct(moddecl, imports, data, protos);
    }

    public ModuleName getFullModuleName() {
        return this.moddecl.getFullModuleName();
    }

    public String toString() {
        String s = this.moddecl.toString();
        for (ImportDecl<?> importDecl : this.imports) {
            s = String.valueOf(s) + "\n" + importDecl;
        }
        for (NonProtocolDecl nonProtocolDecl : this.data) {
            s = String.valueOf(s) + "\n" + nonProtocolDecl;
        }
        for (ProtocolDecl protocolDecl : this.protos) {
            s = String.valueOf(s) + "\n" + protocolDecl;
        }
        return s;
    }

    public DataTypeDecl getDataTypeDecl(DataType simpname) {
        for (NonProtocolDecl<?> dtd : this.data) {
            if (!dtd.isDataTypeDecl() || !((AbstractName)dtd.getDeclName()).equals(simpname)) continue;
            return (DataTypeDecl)dtd;
        }
        throw new RuntimeException("Data type not found: " + simpname);
    }

    public MessageSigNameDecl getMessageSigDecl(MessageSigName simpname) {
        for (NonProtocolDecl<?> dtd : this.data) {
            if (!(dtd instanceof MessageSigNameDecl) || !((AbstractName)dtd.getDeclName()).equals(simpname)) continue;
            return (MessageSigNameDecl)dtd;
        }
        throw new RuntimeException("Message signature not found: " + simpname);
    }

    public List<ImportDecl<?>> getImportDecls() {
        return Collections.unmodifiableList(this.imports);
    }

    public List<NonProtocolDecl<?>> getNonProtocolDecls() {
        return Collections.unmodifiableList(this.data);
    }

    public List<ProtocolDecl<?>> getProtocolDecls() {
        return Collections.unmodifiableList(this.protos);
    }

    public List<GProtocolDecl> getGlobalProtocolDecls() {
        return this.getProtocolDecls(IS_GLOBALPROTOCOLDECL, TO_GLOBALPROTOCOLDECL);
    }

    public List<LProtocolDecl> getLocalProtocolDecls() {
        return this.getProtocolDecls(IS_LOCALPROTOCOLDECL, TO_LOCALPROTOCOLDECL);
    }

    private <T extends ProtocolDecl<?>> List<T> getProtocolDecls(Predicate<ProtocolDecl<?>> filter, Function<ProtocolDecl<?>, T> cast) {
        return this.protos.stream().filter(filter).map(cast).collect(Collectors.toList());
    }

    public <K extends ProtocolKind> boolean hasProtocolDecl(ProtocolName<K> simpname) {
        return Module.hasProtocolDecl(this.protos, simpname);
    }

    public <K extends ProtocolKind> ProtocolDecl<K> getProtocolDecl(ProtocolName<K> simpname) {
        return Module.getProtocolDecl(this.protos, simpname);
    }

    private static <K extends ProtocolKind> boolean hasProtocolDecl(List<ProtocolDecl<?>> pds, ProtocolName<K> simpname) {
        return pds.stream().filter(pd -> ((AbstractName)pd.header.getDeclName()).equals(simpname) && ((ProtocolKind)simpname.getKind()).equals(Global.KIND) ? pd.isGlobal() : pd.isLocal()).count() > 0L;
    }

    private static <K extends ProtocolKind> ProtocolDecl<K> getProtocolDecl(List<ProtocolDecl<?>> pds, ProtocolName<K> simpname) {
        List filtered = pds.stream().filter(pd -> ((AbstractName)pd.header.getDeclName()).equals(simpname) && ((ProtocolKind)simpname.getKind()).equals(Global.KIND) ? pd.isGlobal() : pd.isLocal()).collect(Collectors.toList());
        if (filtered.size() == 0) {
            throw new RuntimeException("Protocol not found: " + simpname);
        }
        ProtocolDecl res = (ProtocolDecl)filtered.get(0);
        return res;
    }
}

