/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import org.scribble.ast.NameDeclNode;
import org.scribble.ast.NonRoleParamDeclList;
import org.scribble.ast.ProtocolKindNode;
import org.scribble.ast.RoleDeclList;
import org.scribble.ast.name.NameNode;
import org.scribble.ast.name.qualified.ProtocolNameNode;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.visit.AstVisitor;

public abstract class ProtocolHeader<K extends ProtocolKind>
extends NameDeclNode<K>
implements ProtocolKindNode<K> {
    public final RoleDeclList roledecls;
    public final NonRoleParamDeclList paramdecls;

    protected ProtocolHeader(NameNode<K> name, RoleDeclList roledecls, NonRoleParamDeclList paramdecls) {
        super(name);
        this.roledecls = roledecls;
        this.paramdecls = paramdecls;
    }

    public abstract ProtocolHeader<K> reconstruct(ProtocolNameNode<K> var1, RoleDeclList var2, NonRoleParamDeclList var3);

    @Override
    public ProtocolHeader<K> visitChildren(AstVisitor nv) throws ScribbleException {
        RoleDeclList rdl = (RoleDeclList)this.visitChild(this.roledecls, nv);
        NonRoleParamDeclList pdl = (NonRoleParamDeclList)this.visitChild(this.paramdecls, nv);
        return this.reconstruct((ProtocolNameNode)this.name, rdl, pdl);
    }

    public boolean isParameterDeclListEmpty() {
        return this.paramdecls.isEmpty();
    }

    public abstract ProtocolNameNode<K> getNameNode();

    @Override
    public ProtocolName<K> getDeclName() {
        return (ProtocolName)super.getDeclName();
    }

    public String toString() {
        String s = "protocol " + this.name;
        if (!this.isParameterDeclListEmpty()) {
            s = String.valueOf(s) + this.paramdecls;
        }
        return String.valueOf(s) + this.roledecls;
    }
}

