/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.scribble.ast.ProtocolKindNode;
import org.scribble.ast.ScribNode;
import org.scribble.del.ScribDel;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.util.ScribUtil;
import org.scribble.visit.AstVisitor;
import org.scribble.visit.Substitutor;

public abstract class ScribNodeBase
implements ScribNode {
    protected ScribDel del;

    protected abstract ScribNodeBase copy();

    @Override
    public abstract ScribNodeBase clone();

    @Override
    public final ScribDel del() {
        return this.del;
    }

    @Override
    public final ScribNodeBase del(ScribDel del) {
        ScribNodeBase copy = this.copy();
        copy.del = del;
        return copy;
    }

    @Override
    public ScribNode accept(AstVisitor nv) throws ScribbleException {
        return nv.visit(null, this);
    }

    @Override
    public ScribNode visitChildren(AstVisitor nv) throws ScribbleException {
        return this;
    }

    protected ScribNode visitChild(ScribNode child, AstVisitor nv) throws ScribbleException {
        return nv.visit(this, child);
    }

    public static final <T extends ScribNode> T del(T n, ScribDel del) {
        ScribNodeBase copy = ((ScribNodeBase)n).copy();
        copy.del = del;
        return ScribUtil.castNodeByClass(n, copy);
    }

    @Override
    public ScribNode substituteNames(Substitutor subs) {
        return this;
    }

    protected static final <T extends ScribNode> T visitChildWithClassEqualityCheck(ScribNode parent, T child, AstVisitor nv) throws ScribbleException {
        ScribNode visited = ((ScribNodeBase)parent).visitChild(child, nv);
        return ScribUtil.checkNodeClassEquality(child, visited);
    }

    protected static final <T extends ScribNode> List<T> visitChildListWithClassEqualityCheck(ScribNode parent, List<T> children, AstVisitor nv) throws ScribbleException {
        return ScribNodeBase.visitChildListWith(parent, children, nv, t -> ScribUtil.handleLambdaScribbleException(() -> ScribNodeBase.visitChildWithClassEqualityCheck(parent, t, nv)));
    }

    protected static final <N extends ProtocolKindNode<?>, K extends ProtocolKind, R extends ProtocolKindNode<K>> R visitChildWithCastCheck(ScribNode parent, ScribNode child, AstVisitor nv, Class<N> clazz, K kind, Function<ScribNode, R> cast) throws ScribbleException {
        ScribNode visited = ((ScribNodeBase)parent).visitChild(child, nv);
        if (!clazz.isAssignableFrom(visited.getClass())) {
            throw new RuntimeException(nv.getClass() + " generic visit error: " + clazz + ", " + visited.getClass());
        }
        ProtocolKindNode pkn = (ProtocolKindNode)visited;
        if (pkn.isGlobal() && !kind.equals(Global.KIND) || pkn.isLocal() && !kind.equals(Local.KIND)) {
            throw new RuntimeException(nv.getClass() + " generic visit error: " + pkn.getClass() + ", " + kind);
        }
        return (R)((ProtocolKindNode)cast.apply(pkn));
    }

    protected static final <T extends ScribNode, N extends ProtocolKindNode<?>, K extends ProtocolKind, R extends ProtocolKindNode<K>> List<R> visitChildListWithCastCheck(ScribNode parent, List<T> children, AstVisitor nv, Class<N> c, K k, Function<ScribNode, R> f) throws ScribbleException {
        return ScribNodeBase.visitChildListWith(parent, children, nv, t -> ScribUtil.handleLambdaScribbleException(() -> ScribNodeBase.visitChildWithCastCheck(parent, t, nv, c, k, f)));
    }

    private static final <T extends ScribNode, R extends ScribNode> List<R> visitChildListWith(ScribNode parent, List<T> children, AstVisitor nv, Function<T, R> c) throws ScribbleException {
        try {
            return children.stream().map(n -> (ScribNode)c.apply(n)).collect(Collectors.toList());
        }
        catch (RuntimeScribbleException rse) {
            Throwable cause = rse.getCause();
            if (cause instanceof ScribbleException) {
                throw (ScribbleException)cause;
            }
            throw (RuntimeException)cause;
        }
    }
}

