/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.PayloadElem;
import org.scribble.ast.ScribNode;
import org.scribble.ast.ScribNodeBase;
import org.scribble.ast.name.PayloadElemNameNode;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.PayloadType;
import org.scribble.util.ScribUtil;
import org.scribble.visit.AstVisitor;

public class UnaryPayloadElem<K extends PayloadTypeKind>
extends ScribNodeBase
implements PayloadElem<K> {
    public final PayloadElemNameNode<K> name;

    public UnaryPayloadElem(PayloadElemNameNode<K> name) {
        this.name = name;
    }

    @Override
    public UnaryPayloadElem<K> project() {
        return this;
    }

    @Override
    protected UnaryPayloadElem<K> copy() {
        return new UnaryPayloadElem<K>(this.name);
    }

    @Override
    public UnaryPayloadElem<K> clone() {
        PayloadElemNameNode<K> name = ScribUtil.checkNodeClassEquality(this.name, (ScribNode)this.name.clone());
        return AstFactoryImpl.FACTORY.UnaryPayloadElem(name);
    }

    public UnaryPayloadElem<K> reconstruct(PayloadElemNameNode<K> name) {
        ScribDel del = this.del();
        UnaryPayloadElem<K> elem = new UnaryPayloadElem<K>(name);
        elem = ScribNodeBase.del(elem, del);
        return elem;
    }

    @Override
    public UnaryPayloadElem<K> visitChildren(AstVisitor nv) throws ScribbleException {
        PayloadElemNameNode name = (PayloadElemNameNode)this.visitChild(this.name, nv);
        return this.reconstruct(name);
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public PayloadType<K> toPayloadType() {
        return this.name.toPayloadType();
    }
}

