/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;

public abstract class DependencyMap<N extends ProtocolName<?>> {
    private final Map<Role, Map<N, Set<Role>>> deps = new HashMap<Role, Map<N, Set<Role>>>();

    public DependencyMap() {
    }

    protected DependencyMap(DependencyMap<N> deps) {
        for (Role r : deps.deps.keySet()) {
            Map<N, Set<Role>> tmp = deps.deps.get(r);
            for (Map.Entry<N, Set<Role>> e : tmp.entrySet()) {
                for (Role rr : e.getValue()) {
                    this.addProtocolDependency(r, (ProtocolName)e.getKey(), rr);
                }
            }
        }
    }

    public abstract DependencyMap<N> clone();

    public void addProtocolDependency(Role self, N pn, Role target) {
        Set<Role> tmp2;
        Map<N, Set<Role>> tmp1 = this.deps.get(self);
        if (tmp1 == null) {
            tmp1 = new HashMap<N, Set<Role>>();
            this.deps.put(self, tmp1);
        }
        if ((tmp2 = tmp1.get(pn)) == null) {
            tmp2 = new HashSet<Role>();
            tmp1.put(pn, tmp2);
        }
        tmp2.add(target);
    }

    public Map<Role, Map<N, Set<Role>>> getDependencies() {
        return this.deps;
    }
}

