/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.context;

import java.util.Map;
import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.ImportDecl;
import org.scribble.ast.ImportModule;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.ast.NonProtocolDecl;
import org.scribble.ast.context.ScribNames;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.ast.local.LProtocolDecl;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.kind.Kind;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.kind.SigKind;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.MemberName;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.Name;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.visit.JobContext;

public class ModuleContext {
    public final ModuleName root;
    private final ScribNames deps = new ScribNames();
    private final ScribNames visible = new ScribNames();

    public ModuleContext(JobContext jcontext, Module root) throws ScribbleException {
        ModuleName fullname = root.getFullModuleName();
        ModuleName simpname = root.moddecl.getDeclName();
        this.root = fullname;
        ModuleContext.addModule(this.deps, root, fullname);
        this.addImportDependencies(jcontext, root);
        ModuleContext.addModule(this.visible, root, fullname);
        if (!fullname.equals(simpname)) {
            ModuleContext.addModule(this.visible, root, simpname);
        }
        this.addVisible(jcontext, root);
    }

    private static void addModule(ScribNames names, Module mod, ModuleName modname) throws ScribbleException {
        ProtocolName qualif;
        names.modules.put(modname, mod.getFullModuleName());
        for (NonProtocolDecl<?> npd : mod.getNonProtocolDecls()) {
            MemberName qualif2;
            if (npd.isDataTypeDecl()) {
                DataTypeDecl dtd = (DataTypeDecl)npd;
                qualif2 = new DataType(modname, dtd.getDeclName());
                names.data.put((DataType)qualif2, dtd.getFullMemberName(mod));
                continue;
            }
            MessageSigNameDecl msnd = (MessageSigNameDecl)npd;
            qualif2 = new MessageSigName(modname, msnd.getDeclName());
            names.sigs.put((MessageSigName)qualif2, msnd.getFullMemberName(mod));
        }
        for (GProtocolDecl gpd : mod.getGlobalProtocolDecls()) {
            qualif = new GProtocolName(modname, gpd.getHeader().getDeclName());
            names.globals.put((GProtocolName)qualif, gpd.getFullMemberName(mod));
        }
        for (LProtocolDecl lpd : mod.getLocalProtocolDecls()) {
            qualif = new LProtocolName(modname, lpd.getHeader().getDeclName());
            names.locals.put((LProtocolName)qualif, lpd.getFullMemberName(mod));
        }
    }

    private void addImportDependencies(JobContext jcontext, Module mod) throws ScribbleException {
        for (ImportDecl<?> id : mod.getImportDecls()) {
            if (id.isImportModule()) {
                ImportModule im = (ImportModule)id;
                ModuleName fullmodname = im.modname.toName();
                if (this.deps.modules.containsKey(fullmodname)) continue;
                Module imported = jcontext.getModule(fullmodname);
                ModuleContext.addModule(this.deps, imported, fullmodname);
                this.addImportDependencies(jcontext, imported);
                continue;
            }
            throw new RuntimeException("TODO: " + id);
        }
    }

    private void addVisible(JobContext jcontext, Module root) throws ScribbleException {
        ProtocolName visname;
        for (ImportDecl<?> importDecl : root.getImportDecls()) {
            if (importDecl.isImportModule()) {
                ModuleName visname2;
                ImportModule im = (ImportModule)importDecl;
                ModuleName fullname = im.modname.toName();
                ModuleName moduleName = visname2 = im.isAliased() ? im.getAlias() : fullname;
                if (this.visible.modules.containsKey(visname2)) {
                    throw new ScribbleException("Duplicate visible module name: " + visname2);
                }
                Module imported = jcontext.getModule(fullname);
                ModuleContext.addModule(this.visible, imported, visname2);
                continue;
            }
            throw new RuntimeException("TODO: " + importDecl);
        }
        for (NonProtocolDecl nonProtocolDecl : root.getNonProtocolDecls()) {
            if (nonProtocolDecl.isDataTypeDecl()) {
                DataTypeDecl dtd = (DataTypeDecl)nonProtocolDecl;
                DataType visname3 = new DataType(dtd.getDeclName().toString());
                this.visible.data.put(visname3, dtd.getFullMemberName(root));
                continue;
            }
            MessageSigNameDecl msnd = (MessageSigNameDecl)nonProtocolDecl;
            MessageSigName visname2 = new MessageSigName(msnd.getDeclName().toString());
            this.visible.sigs.put(visname2, msnd.getFullMemberName(root));
        }
        for (GProtocolDecl gProtocolDecl : root.getGlobalProtocolDecls()) {
            visname = new GProtocolName(gProtocolDecl.getHeader().getDeclName().toString());
            this.visible.globals.put((GProtocolName)visname, gProtocolDecl.getFullMemberName(root));
        }
        for (LProtocolDecl lProtocolDecl : root.getLocalProtocolDecls()) {
            visname = new LProtocolName(lProtocolDecl.getHeader().getDeclName().toString());
            this.visible.locals.put((LProtocolName)visname, lProtocolDecl.getFullMemberName(root));
        }
    }

    public <K extends ProtocolKind> ProtocolName<K> checkProtocolDeclDependencyFullName(ProtocolName<K> proto) {
        return ModuleContext.getProtocolDeclFullName(this.deps, proto);
    }

    public boolean isDataTypeVisible(DataType typename) {
        return this.visible.data.keySet().contains(typename);
    }

    public boolean isMessageSigNameVisible(Name<? extends SigKind> signame) {
        return this.visible.sigs.containsKey(signame);
    }

    public DataType getVisibleDataTypeFullName(DataType visname) {
        return ModuleContext.getFullName(this.visible.data, visname);
    }

    public boolean isVisibleDataType(DataType visname) {
        return this.visible.isVisibleDataType(visname);
    }

    public MessageSigName getVisibleMessageSigNameFullName(MessageSigName visname) {
        return ModuleContext.getFullName(this.visible.sigs, visname);
    }

    public <K extends ProtocolKind> ProtocolName<K> getVisibleProtocolDeclFullName(ProtocolName<K> visname) {
        return ModuleContext.getProtocolDeclFullName(this.visible, visname);
    }

    public <K extends ProtocolKind> boolean isVisibleProtocolDeclName(ProtocolName<K> visname) {
        return this.visible.isVisibleProtocolDeclName(visname);
    }

    public static <K extends ProtocolKind> ProtocolName<K> getProtocolDeclFullName(ScribNames names, ProtocolName<K> proto) {
        ProtocolName pn;
        ProtocolName tmp = pn = ((ProtocolKind)proto.getKind()).equals(Global.KIND) ? (ProtocolName)ModuleContext.getFullName(names.globals, (GProtocolName)proto) : (ProtocolName)ModuleContext.getFullName(names.locals, (LProtocolName)proto);
        return tmp;
    }

    private static <T extends Name<K>, K extends Kind> T getFullName(Map<T, T> map, T visname) {
        if (!map.containsKey(visname)) {
            throw new RuntimeException("Unknown name: " + visname);
        }
        return (T)((Name)map.get(visname));
    }

    public String toString() {
        return "[deps=" + this.deps + ", visible=" + this.visible + "]";
    }
}

