/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.scribble.ast.context.DependencyMap;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;

public abstract class ProtocolDeclContext<K extends ProtocolKind> {
    private Set<Role> roles;
    private DependencyMap<? extends ProtocolName<K>> deps;

    protected ProtocolDeclContext(Set<Role> roles, DependencyMap<? extends ProtocolName<K>> deps) {
        this.roles = new HashSet<Role>(roles);
        this.deps = deps.clone();
    }

    protected abstract ProtocolDeclContext<K> copy();

    public Set<Role> getRoleOccurrences() {
        return Collections.unmodifiableSet(this.roles);
    }

    public ProtocolDeclContext<K> setRoleOccurrences(Collection<Role> roles) {
        ProtocolDeclContext<K> copy = this.copy();
        copy.roles = new HashSet<Role>(roles);
        copy.deps = this.deps.clone();
        return copy;
    }

    public DependencyMap<? extends ProtocolName<K>> getDependencyMap() {
        return this.deps;
    }
}

