/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.global;

import java.util.Collections;
import java.util.List;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.Module;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ProtocolDef;
import org.scribble.ast.ProtocolHeader;
import org.scribble.ast.global.GNode;
import org.scribble.ast.global.GProtocolDef;
import org.scribble.ast.global.GProtocolHeader;
import org.scribble.del.ScribDel;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.sesstype.name.ProtocolName;

public class GProtocolDecl
extends ProtocolDecl<Global>
implements GNode {
    public final List<Modifiers> modifiers;

    public GProtocolDecl(List<Modifiers> modifiers, GProtocolHeader header, GProtocolDef def) {
        super(header, def);
        this.modifiers = Collections.unmodifiableList(modifiers);
    }

    @Override
    protected GProtocolDecl copy() {
        return new GProtocolDecl(this.modifiers, this.getHeader(), this.getDef());
    }

    @Override
    public GProtocolDecl clone() {
        GProtocolHeader header = this.getHeader().clone();
        GProtocolDef def = this.getDef().clone();
        return AstFactoryImpl.FACTORY.GProtocolDecl(this.modifiers, header, def);
    }

    public GProtocolDecl reconstruct(ProtocolHeader<Global> header, ProtocolDef<Global> def) {
        ScribDel del = this.del();
        GProtocolDecl gpd = new GProtocolDecl(this.modifiers, (GProtocolHeader)header, (GProtocolDef)def);
        gpd = (GProtocolDecl)gpd.del(del);
        return gpd;
    }

    public GProtocolHeader getHeader() {
        return (GProtocolHeader)this.header;
    }

    public GProtocolDef getDef() {
        return (GProtocolDef)this.def;
    }

    public GProtocolName getFullMemberName(Module mod) {
        ModuleName fullmodname = mod.getFullModuleName();
        return new GProtocolName(fullmodname, (ProtocolName<Global>)this.header.getDeclName());
    }

    @Override
    public boolean isGlobal() {
        return GNode.super.isGlobal();
    }

    @Override
    public Global getKind() {
        return GNode.super.getKind();
    }

    public boolean isExplicitModifier() {
        return this.modifiers.contains((Object)Modifiers.EXPLICIT);
    }

    public boolean isAuxModifier() {
        return this.modifiers.contains((Object)Modifiers.AUX);
    }

    public static enum Modifiers {
        EXPLICIT,
        AUX;

    }
}

