/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.global;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.ConnectionAction;
import org.scribble.ast.Do;
import org.scribble.ast.MessageTransfer;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.Recursion;
import org.scribble.ast.global.GCompoundInteractionNode;
import org.scribble.ast.global.GProtocolBlock;
import org.scribble.ast.local.LChoice;
import org.scribble.ast.local.LContinue;
import org.scribble.ast.local.LInteractionNode;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.ast.local.LRecursion;
import org.scribble.ast.name.simple.RecVarNode;
import org.scribble.del.ScribDel;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.RecVar;
import org.scribble.sesstype.name.Role;

public class GRecursion
extends Recursion<Global>
implements GCompoundInteractionNode {
    public GRecursion(RecVarNode recvar, GProtocolBlock block) {
        super(recvar, block);
    }

    public LRecursion project(Role self, LProtocolBlock block) {
        RecVarNode recvar = this.recvar.clone();
        LRecursion projection = null;
        HashSet<RecVar> rvs = new HashSet<RecVar>();
        rvs.add(recvar.toName());
        LProtocolBlock pruned = GRecursion.prune(block, rvs);
        if (!pruned.isEmpty()) {
            projection = AstFactoryImpl.FACTORY.LRecursion(recvar, pruned);
        }
        return projection;
    }

    private static LProtocolBlock prune(LProtocolBlock block, Set<RecVar> rvs) {
        if (block.isEmpty()) {
            return block;
        }
        List<LInteractionNode> lis = block.getInteractionSeq().getInteractions();
        if (lis.size() > 1) {
            return block;
        }
        LInteractionNode lin = lis.get(0);
        if (lin instanceof LContinue) {
            if (rvs.contains(((LContinue)lin).recvar.toName())) {
                return AstFactoryImpl.FACTORY.LProtocolBlock(AstFactoryImpl.FACTORY.LInteractionSeq(Collections.emptyList()));
            }
            return block;
        }
        if (lin instanceof MessageTransfer || lin instanceof Do || lin instanceof ConnectionAction) {
            return block;
        }
        if (lin instanceof LChoice) {
            LinkedList<LProtocolBlock> pruned = new LinkedList<LProtocolBlock>();
            for (LProtocolBlock b : ((LChoice)lin).getBlocks()) {
                if (GRecursion.prune(b, rvs).isEmpty()) continue;
                pruned.add(b);
            }
            if (pruned.isEmpty()) {
                return AstFactoryImpl.FACTORY.LProtocolBlock(AstFactoryImpl.FACTORY.LInteractionSeq(Collections.emptyList()));
            }
            return AstFactoryImpl.FACTORY.LProtocolBlock(AstFactoryImpl.FACTORY.LInteractionSeq(Arrays.asList(AstFactoryImpl.FACTORY.LChoice(((LChoice)lin).subj, pruned))));
        }
        if (lin instanceof LRecursion) {
            rvs = new HashSet<RecVar>(rvs);
            LProtocolBlock prune = GRecursion.prune(((LRecursion)lin).getBlock(), rvs);
            if (prune.isEmpty()) {
                return prune;
            }
            return AstFactoryImpl.FACTORY.LProtocolBlock(AstFactoryImpl.FACTORY.LInteractionSeq(Arrays.asList(AstFactoryImpl.FACTORY.LRecursion(((LRecursion)lin).recvar, prune))));
        }
        throw new RuntimeException("TODO: " + lin);
    }

    @Override
    protected GRecursion copy() {
        return new GRecursion(this.recvar, this.getBlock());
    }

    @Override
    public GRecursion clone() {
        RecVarNode recvar = this.recvar.clone();
        GProtocolBlock block = this.getBlock().clone();
        return AstFactoryImpl.FACTORY.GRecursion(recvar, block);
    }

    public GRecursion reconstruct(RecVarNode recvar, ProtocolBlock<Global> block) {
        ScribDel del = this.del();
        GRecursion gr = new GRecursion(recvar, (GProtocolBlock)block);
        gr = (GRecursion)gr.del(del);
        return gr;
    }

    public GProtocolBlock getBlock() {
        return (GProtocolBlock)this.block;
    }

    @Override
    public Global getKind() {
        return GCompoundInteractionNode.super.getKind();
    }
}

