/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.name;

import java.util.Arrays;
import org.scribble.ast.ScribNodeBase;
import org.scribble.sesstype.kind.Kind;
import org.scribble.sesstype.name.Named;

public abstract class NameNode<K extends Kind>
extends ScribNodeBase
implements Named<K> {
    protected final String[] elems;

    public NameNode(String ... elems) {
        this.elems = elems;
    }

    @Override
    public abstract NameNode<K> clone();

    public String[] getElements() {
        return Arrays.copyOf(this.elems, this.elems.length);
    }

    public int getElementCount() {
        return this.elems.length;
    }

    public boolean isEmpty() {
        return this.elems.length == 0;
    }

    protected boolean isPrefixed() {
        return this.elems.length > 1;
    }

    protected String[] getPrefixElements() {
        return Arrays.copyOfRange(this.elems, 0, this.elems.length - 1);
    }

    protected String getLastElement() {
        return this.elems[this.elems.length - 1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NameNode)) {
            return false;
        }
        NameNode nn = (NameNode)o;
        return nn.canEqual(this) && Arrays.equals(this.elems, nn.elems);
    }

    public abstract boolean canEqual(Object var1);

    public int hashCode() {
        int hash = 317;
        hash = 31 * hash + this.elems.hashCode();
        return hash;
    }

    public String toString() {
        return this.toName().toString();
    }
}

