/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.Set;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;

public class AcceptSocketGenerator
extends ScribSocketGenerator {
    public AcceptSocketGenerator(StateChannelApiGenerator apigen, EndpointState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.AcceptSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        super.addImports();
    }

    @Override
    protected void addMethods() {
        Set as = this.curr.getTakeable();
        if (as.size() > 1) {
            throw new RuntimeException("AcceptSocket generation not yet supported for accept-branches: " + as);
        }
        IOAction a = (IOAction)as.iterator().next();
        EndpointState succ = (EndpointState)this.curr.take(a);
        this.makeAcceptMethod(a, succ);
    }

    private void makeAcceptMethod(IOAction a, EndpointState succ) {
        MethodBuilder mb = this.makeAcceptHeader(a, succ);
        mb.addBodyLine("super.accept(ss, " + this.getSessionApiRoleConstant(a.obj) + ");");
        this.addReturnNextSocket(mb, succ);
    }

    private MethodBuilder makeAcceptHeader(IOAction a, EndpointState succ) {
        MethodBuilder mb = this.cb.newMethod();
        AcceptSocketGenerator.setAcceptHeaderWithoutReturnType(this.apigen, a, mb);
        AcceptSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    public static void setAcceptHeaderWithoutReturnType(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb) {
        String ROLE_PARAM = "role";
        mb.setName("accept");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException");
        mb.addParameters("org.scribble.net.scribsock.ScribServerSocket ss", String.valueOf(SessionApiGenerator.getRoleClassName(a.obj)) + " " + "role");
    }
}

