/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.stream.Collectors;
import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.CaseSocketGenerator;
import org.scribble.codegen.java.endpointapi.HandlerInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.BranchInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.HandleInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.EnumBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.PayloadType;
import org.scribble.sesstype.name.Role;

public class BranchSocketGenerator
extends ScribSocketGenerator {
    public BranchSocketGenerator(StateChannelApiGenerator apigen, EndpointState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.BranchSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        this.cb.addImports("java.io.IOException");
        super.addImports();
    }

    @Override
    protected void addMethods() throws ScribbleException {
        String ROLE_PARAM = "role";
        String MESSAGE_VAR = "m";
        String OPENUM_VAR = "openum";
        String OP = "m.op";
        Module main = this.apigen.getMainModule();
        ClassBuilder caseclass = new CaseSocketGenerator(this.apigen, this.curr).generateType();
        String next = caseclass.getName();
        String enumClass = BranchSocketGenerator.getBranchEnumClassName(this.apigen, this.curr);
        Role peer = ((IOAction)this.curr.getTakeable().iterator().next()).obj;
        this.addBranchMethod("role", "m", "openum", "m.op", peer, next, enumClass);
        if (this.apigen.skipIOInterfacesGeneration) {
            EnumBuilder eb = this.cb.newMemberEnum(enumClass);
            eb.addModifiers("public");
            eb.addInterfaces("org.scribble.net.session.OpEnum");
            this.curr.getTakeable().stream().forEach(a -> eb.addValues(SessionApiGenerator.getOpClassName(a.mid)));
        } else {
            String handleif = this.addBranchCallbackMethod("role", peer);
            this.addHandleInterfaceCallbackMethod("role", "m", "m.op", main, peer, handleif);
            this.addHandleMethod("role", "m", "m.op", main, peer);
        }
        this.apigen.addTypeDecl(new HandlerInterfaceGenerator(this.apigen, this.cb, this.curr).generateType());
    }

    private void addBranchMethod(String ROLE_PARAM, String MESSAGE_VAR, String OPENUM_VAR, String OP, Role peer, String next, String enumClass) {
        MethodBuilder mb = this.cb.newMethod("branch");
        mb.setReturn(next);
        mb.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(((IOAction)this.curr.getTakeable().iterator().next()).obj)) + " " + ROLE_PARAM);
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException", "ClassNotFoundException");
        if (!this.apigen.skipIOInterfacesGeneration) {
            mb.addAnnotations("@Override");
        }
        mb.addBodyLine("org.scribble.net.ScribMessage " + MESSAGE_VAR + " = " + "super" + ".readScribMessage(" + this.getSessionApiRoleConstant(peer) + ");");
        mb.addBodyLine(String.valueOf(enumClass) + " " + OPENUM_VAR + ";");
        boolean first = true;
        for (IOAction a : this.curr.getTakeable()) {
            mb.addBodyLine(String.valueOf(first ? "" : "else ") + "if (" + OP + ".equals(" + this.getSessionApiOpConstant(a.mid) + ")) {");
            mb.addBodyLine(1, String.valueOf(OPENUM_VAR) + " = " + enumClass + "." + SessionApiGenerator.getOpClassName(a.mid) + ";");
            mb.addBodyLine("}");
            first = false;
        }
        mb.addBodyLine("else {");
        mb.addBodyLine(1, "throw new RuntimeException(\"Won't get here: \" + " + OP + ");");
        mb.addBodyLine("}");
        mb.addBodyLine("return new " + next + "(" + "this.se" + ", true, " + OPENUM_VAR + ", " + MESSAGE_VAR + ");");
    }

    private String addBranchCallbackMethod(String ROLE_PARAM, Role peer) {
        String handlerif = HandlerInterfaceGenerator.getHandlerInterfaceName(this.cb.getName());
        String handleif = HandleInterfaceGenerator.getHandleInterfaceName(this.apigen.getSelf(), this.curr);
        MethodBuilder mb2 = this.cb.newMethod("branch");
        mb2.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(peer)) + " " + ROLE_PARAM);
        mb2.addParameters(String.valueOf(handlerif) + " handler");
        mb2.setReturn("void");
        mb2.addModifiers("public");
        mb2.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException", "ClassNotFoundException");
        boolean first = true;
        handleif = String.valueOf(handleif) + "<";
        for (IOAction a : this.curr.getTakeable().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList())) {
            if (first) {
                first = false;
            } else {
                handleif = String.valueOf(handleif) + ", ";
            }
            EndpointState succ = (EndpointState)this.curr.take(a);
            handleif = succ.isTerminal() ? String.valueOf(handleif) + "EndSocket" : String.valueOf(handleif) + this.apigen.getSocketClassName(succ);
        }
        handleif = String.valueOf(handleif) + ">";
        mb2.addBodyLine("branch(role, (" + handleif + ") handler);");
        return handleif;
    }

    private void addHandleInterfaceCallbackMethod(String ROLE_PARAM, String MESSAGE_VAR, String OP, Module main, Role peer, String handleif) {
        MethodBuilder mb3 = this.cb.newMethod("branch");
        mb3.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(peer)) + " " + ROLE_PARAM);
        mb3.addParameters(String.valueOf(handleif) + " handler");
        mb3.setReturn("void");
        mb3.addModifiers("public");
        mb3.addAnnotations("@Override");
        mb3.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException", "ClassNotFoundException");
        mb3.addBodyLine("org.scribble.net.ScribMessage " + MESSAGE_VAR + " = " + "super" + ".readScribMessage(" + this.getSessionApiRoleConstant(peer) + ");");
        boolean first = true;
        for (IOAction a : this.curr.getTakeable()) {
            EndpointState succ = (EndpointState)this.curr.take(a);
            if (first) {
                first = false;
            } else {
                mb3.addBodyLine("else");
            }
            mb3.addBodyLine("if (" + MESSAGE_VAR + "." + "op" + ".equals(" + this.getSessionApiOpConstant(a.mid) + ")) {");
            if (succ.isTerminal()) {
                mb3.addBodyLine(1, "this.se.setCompleted();");
            }
            String ln = "handler.receive(";
            ln = String.valueOf(ln) + "new " + (succ.isTerminal() ? "EndSocket" : this.apigen.getSocketClassName(succ)) + "(" + "this.se" + ", true), ";
            ln = String.valueOf(ln) + this.getSessionApiOpConstant(a.mid);
            if (a.mid.isOp()) {
                if (!a.payload.isEmpty()) {
                    String buffSuper = "new org.scribble.net.Buf<>(";
                    int i = 0;
                    for (PayloadType<? extends PayloadTypeKind> pt : a.payload.elems) {
                        DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                        ln = String.valueOf(ln) + ", " + buffSuper + "(" + dtd.extName + ") " + "m" + "." + "payload" + "[" + i++ + "])";
                    }
                }
            } else {
                MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
                ln = String.valueOf(ln) + ", new org.scribble.net.Buf<>((" + msd.extName + ") " + "m" + "." + "payload" + "[0])";
            }
            ln = String.valueOf(ln) + ");";
            mb3.addBodyLine(1, ln);
            mb3.addBodyLine("}");
        }
        mb3.addBodyLine("else {");
        mb3.addBodyLine(1, "throw new RuntimeException(\"Won't get here: \" + " + OP + ");");
        mb3.addBodyLine("}");
    }

    private void addHandleMethod(String ROLE_PARAM, String MESSAGE_VAR, String OP, Module main, Role peer) {
        MethodBuilder mb4 = this.cb.newMethod("handle");
        mb4.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(peer)) + " " + ROLE_PARAM);
        String tmp = String.valueOf(HandleInterfaceGenerator.getHandleInterfaceName(this.apigen.getSelf(), this.curr)) + "<";
        tmp = String.valueOf(tmp) + this.curr.getTakeable().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).map(a -> SuccessorInterfaceGenerator.getSuccessorInterfaceName(a)).collect(Collectors.joining(", ")) + ">";
        mb4.addParameters(String.valueOf(tmp) + " handler");
        mb4.setReturn("void");
        mb4.addModifiers("public");
        mb4.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException", "ClassNotFoundException");
        mb4.addAnnotations("@Override");
        mb4.addBodyLine("org.scribble.net.ScribMessage " + MESSAGE_VAR + " = " + "super" + ".readScribMessage(" + this.getSessionApiRoleConstant(peer) + ");");
        boolean first = true;
        for (IOAction a2 : this.curr.getTakeable()) {
            EndpointState succ = (EndpointState)this.curr.take(a2);
            if (first) {
                first = false;
            } else {
                mb4.addBodyLine("else");
            }
            mb4.addBodyLine("if (" + MESSAGE_VAR + "." + "op" + ".equals(" + this.getSessionApiOpConstant(a2.mid) + ")) {");
            if (succ.isTerminal()) {
                mb4.addBodyLine(1, "this.se.setCompleted();");
            }
            String ln = "handler.receive(";
            ln = String.valueOf(ln) + "new " + (succ.isTerminal() ? "EndSocket" : this.apigen.getSocketClassName(succ)) + "(" + "this.se" + ", true), ";
            ln = String.valueOf(ln) + this.getSessionApiOpConstant(a2.mid);
            if (a2.mid.isOp()) {
                if (!a2.payload.isEmpty()) {
                    String buffSuper = "new org.scribble.net.Buf<>(";
                    int i = 0;
                    for (PayloadType<? extends PayloadTypeKind> pt : a2.payload.elems) {
                        DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                        ln = String.valueOf(ln) + ", " + buffSuper + "(" + dtd.extName + ") " + "m" + "." + "payload" + "[" + i++ + "])";
                    }
                }
            } else {
                MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a2.mid).getSimpleName());
                ln = String.valueOf(ln) + ", new org.scribble.net.Buf<>((" + msd.extName + ") " + "m" + "." + "payload" + "[0])";
            }
            ln = String.valueOf(ln) + ");";
            mb4.addBodyLine(1, ln);
            mb4.addBodyLine("}");
        }
        mb4.addBodyLine("else {");
        mb4.addBodyLine(1, "throw new RuntimeException(\"Won't get here: \" + " + OP + ");");
        mb4.addBodyLine("}");
    }

    protected static String getBranchEnumClassName(StateChannelApiGenerator apigen, EndpointState curr) {
        return apigen.skipIOInterfacesGeneration ? String.valueOf(apigen.getSocketClassName(curr)) + "_Enum" : BranchInterfaceGenerator.getBranchInterfaceEnumName(apigen.getSelf(), curr);
    }
}

