/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.stream.Collectors;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.BranchSocketGenerator;
import org.scribble.codegen.java.endpointapi.ReceiveSocketGenerator;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.BranchInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.Role;

public class CaseSocketGenerator
extends ScribSocketGenerator {
    public CaseSocketGenerator(StateChannelApiGenerator apigen, EndpointState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getClassName() {
        return CaseSocketGenerator.getCaseSocketName(super.getClassName());
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.CaseSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        super.addImports();
        this.cb.addImports(String.valueOf(this.getOpsPackageName()) + ".*");
    }

    @Override
    protected void addInitialStateConstructor() {
    }

    @Override
    protected MethodBuilder addConstructor() {
        String branchName = this.apigen.getSocketClassName(this.curr);
        String enumClassName = String.valueOf(branchName) + "." + BranchSocketGenerator.getBranchEnumClassName(this.apigen, this.curr);
        MethodBuilder ctor = super.addConstructor();
        ctor.addParameters(String.valueOf(enumClassName) + " " + "op", "org.scribble.net.ScribMessage m");
        ctor.addBodyLine("this.op = op;");
        ctor.addBodyLine("this.m = m;");
        return ctor;
    }

    @Override
    protected void addMethods() throws ScribbleException {
        String branchName = this.apigen.getSocketClassName(this.curr);
        String enumClassName = String.valueOf(branchName) + "." + BranchSocketGenerator.getBranchEnumClassName(this.apigen, this.curr);
        FieldBuilder fb1 = this.cb.newField("op");
        fb1.addModifiers("public", "final");
        fb1.setType(enumClassName);
        FieldBuilder fb2 = this.cb.newField("m");
        fb2.addModifiers("private", "final");
        fb2.setType("org.scribble.net.ScribMessage");
        for (IOAction a : this.curr.getTakeable()) {
            EndpointState succ = (EndpointState)this.curr.take(a);
            this.addReceiveMethod(this.cb, a, succ);
            this.addCaseReceiveMethod(this.cb, a, succ);
            if (a.payload.isEmpty() && !a.mid.isMessageSigName()) continue;
            this.addCaseReceiveDiscardMethod(this.cb, a, succ);
        }
        if (!this.apigen.skipIOInterfacesGeneration) {
            Role self = this.apigen.getSelf();
            MethodBuilder mb = this.cb.newMethod("getOp");
            mb.addAnnotations("@Override");
            mb.addModifiers("public");
            mb.setReturn(String.valueOf(IOStateInterfaceGenerator.getIOStateInterfaceName(self, this.curr)) + "." + BranchInterfaceGenerator.getBranchInterfaceEnumName(self, this.curr));
            mb.addBodyLine("return this.op;");
        }
        this.apigen.addTypeDecl(this.cb);
    }

    private MethodBuilder makeReceiveHeader(ClassBuilder cb, IOAction a, EndpointState succ) throws ScribbleException {
        MethodBuilder mb = cb.newMethod();
        ReceiveSocketGenerator.setReceiveHeaderWithoutReturnType(this.apigen, a, mb);
        CaseSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    private void addReceiveMethod(ClassBuilder cb, IOAction a, EndpointState succ) throws ScribbleException {
        Module main = this.apigen.getMainModule();
        MethodBuilder mb = this.makeReceiveHeader(cb, a, succ);
        if (a.mid.isOp()) {
            mb.addBodyLine("super.use();");
            CaseSocketGenerator.addBranchCheck(this.getSessionApiOpConstant(a.mid), mb, "m");
            ReceiveSocketGenerator.addPayloadBuffSetters(main, a, mb);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            mb.addBodyLine("super.use();");
            CaseSocketGenerator.addBranchCheck(this.getSessionApiOpConstant(a.mid), mb, "m");
            mb.addBodyLine("arg.val = (" + msd.extName + ") " + "m" + ";");
        }
        this.addReturnNextSocket(mb, succ);
    }

    private MethodBuilder makeCaseReceiveHeader(ClassBuilder cb, IOAction a, EndpointState succ) throws ScribbleException {
        MethodBuilder mb = cb.newMethod();
        CaseSocketGenerator.setCaseReceiveHeaderWithoutReturnType(this.apigen, a, mb);
        CaseSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    private void addCaseReceiveMethod(ClassBuilder cb, IOAction a, EndpointState succ) throws ScribbleException {
        MethodBuilder mb = this.makeCaseReceiveHeader(cb, a, succ);
        String ln = "return receive(" + this.getSessionApiRoleConstant(a.obj) + ", ";
        boolean first = true;
        for (String param : mb.getParameters()) {
            if (first) {
                first = false;
            } else {
                ln = String.valueOf(ln) + ", ";
            }
            if (param.contains("<")) {
                param = param.substring(param.lastIndexOf(62) + 1, param.length());
            }
            ln = String.valueOf(ln) + param.substring(param.indexOf(" ") + 1, param.length());
        }
        mb.addBodyLine(String.valueOf(ln) + ");");
    }

    private void addCaseReceiveDiscardMethod(ClassBuilder cb, IOAction a, EndpointState succ) {
        Module main = this.apigen.getMainModule();
        MethodBuilder mb = cb.newMethod();
        CaseSocketGenerator.setCaseReceiveDiscardHeaderWithoutReturnType(this.apigen, a, mb);
        CaseSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        mb.addAnnotations("@SuppressWarnings(\"unchecked\")");
        String ln = "return ";
        ln = String.valueOf(ln) + "receive(op, ";
        if (a.mid.isOp()) {
            ln = String.valueOf(ln) + a.payload.elems.stream().map(pt -> this.getGarbageBuf(module.getDataTypeDecl((DataType)((DataType)pt)).extName)).collect(Collectors.joining(", ")) + ");";
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            ln = String.valueOf(ln) + this.getGarbageBuf(msd.extName) + ");";
        }
        mb.addBodyLine(ln);
    }

    private static void addBranchCheck(String opClassName, MethodBuilder mb, String messageField) {
        String op = "this." + messageField + "." + "op";
        mb.addBodyLine("if (!" + op + ".equals(" + opClassName + ")) {");
        mb.addBodyLine(1, "throw new org.scribble.main.ScribbleRuntimeException(\"Wrong branch, received: \" + " + op + ");");
        mb.addBodyLine("}");
    }

    public static void setCaseReceiveHeaderWithoutReturnType(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb) throws ScribbleException {
        Module main = apigen.getMainModule();
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        mb.setName("receive");
        mb.addModifiers("public");
        mb.addParameters(String.valueOf(opClass) + " " + "op");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        if (a.mid.isOp()) {
            ReceiveSocketGenerator.addReceiveOpParams(mb, main, a, true);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            ReceiveSocketGenerator.addReceiveMessageSigNameParams(mb, msd, true);
        }
    }

    public static void setCaseReceiveDiscardHeaderWithoutReturnType(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb) {
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        mb.setName("receive");
        mb.addModifiers("public");
        mb.addParameters(String.valueOf(opClass) + " " + "op");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
    }

    public static String getCaseSocketName(String branchSocketName) {
        return String.valueOf(branchSocketName) + "_Cases";
    }
}

