/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.AuxStateChannelTypeGenerator;
import org.scribble.codegen.java.endpointapi.ReceiveSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.MessageSigName;

public class HandlerInterfaceGenerator
extends AuxStateChannelTypeGenerator {
    private final EndpointState curr;

    public HandlerInterfaceGenerator(StateChannelApiGenerator apigen, ClassBuilder parent, EndpointState curr) {
        super(apigen, parent);
        this.curr = curr;
    }

    @Override
    public InterfaceBuilder generateType() throws ScribbleException {
        GProtocolName gpn = this.apigen.getGProtocolName();
        InterfaceBuilder ib = new InterfaceBuilder();
        ib.setPackage(SessionApiGenerator.getStateChannelPackageName(gpn, this.apigen.getSelf()));
        ib.addImports(String.valueOf(SessionApiGenerator.getOpsPackageName(gpn)) + ".*");
        ib.setName(HandlerInterfaceGenerator.getHandlerInterfaceName(this.parent.getName()));
        ib.addModifiers("public");
        for (IOAction a : this.curr.getTakeable()) {
            EndpointState succ = (EndpointState)this.curr.take(a);
            String nextClass = this.apigen.getSocketClassName(succ);
            AbstractMethodBuilder mb3 = ib.newAbstractMethod();
            if (!this.apigen.skipIOInterfacesGeneration) {
                mb3.addAnnotations("@Override");
            }
            HandlerInterfaceGenerator.setHandleMethodHeaderWithoutParamTypes(this.apigen, mb3);
            if (succ.isTerminal()) {
                mb3.addParameters("EndSocket schan");
            } else {
                mb3.addParameters(String.valueOf(nextClass) + " schan");
            }
            HandlerInterfaceGenerator.addHandleMethodOpAndPayloadParams(this.apigen, a, mb3);
            if (!((EndpointState)this.curr.take(a)).isTerminal()) continue;
            ib.addImports(String.valueOf(SessionApiGenerator.getEndpointApiRootPackageName(gpn)) + ".*");
            ib.addImports(String.valueOf(SessionApiGenerator.getRolesPackageName(this.apigen.getGProtocolName())) + ".*");
        }
        return ib;
    }

    public static void setHandleMethodHeaderWithoutParamTypes(StateChannelApiGenerator apigen, MethodBuilder mb) {
        mb.setName("receive");
        mb.addModifiers("public");
        mb.setReturn("void");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
    }

    public static void addHandleMethodOpAndPayloadParams(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb) throws ScribbleException {
        Module main = apigen.getMainModule();
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        mb.addParameters(String.valueOf(opClass) + " " + "op");
        if (a.mid.isOp()) {
            ReceiveSocketGenerator.addReceiveOpParams(mb, apigen.getMainModule(), a, false);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            ReceiveSocketGenerator.addReceiveMessageSigNameParams(mb, msd, false);
        }
    }

    public static String getHandlerInterfaceName(String branchName) {
        return String.valueOf(branchName) + "_Handler";
    }
}

