/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.InputFutureGenerator;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.PayloadType;

public class ReceiveSocketGenerator
extends ScribSocketGenerator {
    public ReceiveSocketGenerator(StateChannelApiGenerator apigen, EndpointState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.ReceiveSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        super.addImports();
        this.cb.addImports(String.valueOf(this.getOpsPackageName()) + ".*");
    }

    @Override
    protected void addMethods() throws ScribbleException {
        IOAction a = (IOAction)this.curr.getTakeable().iterator().next();
        EndpointState succ = (EndpointState)this.curr.take(a);
        ClassBuilder futureClass = new InputFutureGenerator(this.apigen, this.cb, a).generateType();
        this.apigen.addTypeDecl(futureClass);
        this.makeReceiveMethod(a, succ);
        this.makeAsyncMethod(a, succ, futureClass.getName());
        this.makeIsDoneMethod(a);
        this.makeAsyncDiscardMethod(a, succ, futureClass.getName());
    }

    private void makeReceiveMethod(IOAction a, EndpointState succ) throws ScribbleException {
        Module main = this.apigen.getMainModule();
        MethodBuilder mb = this.makeReceiveHeader(a, succ);
        if (a.mid.isOp()) {
            String ln = a.payload.isEmpty() ? "" : "org.scribble.net.ScribMessage m = ";
            ln = String.valueOf(ln) + "super.readScribMessage(" + this.getSessionApiRoleConstant(a.obj) + ");";
            mb.addBodyLine(ln);
            ReceiveSocketGenerator.addPayloadBuffSetters(main, a, mb);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            mb.addBodyLine("org.scribble.net.ScribMessage m = super.readScribMessage(" + this.getSessionApiRoleConstant(a.obj) + ");");
            mb.addBodyLine("arg.val = (" + msd.extName + ") " + "m" + ";");
        }
        this.addReturnNextSocket(mb, succ);
    }

    private MethodBuilder makeReceiveHeader(IOAction a, EndpointState succ) throws ScribbleException {
        MethodBuilder mb = this.cb.newMethod();
        ReceiveSocketGenerator.setReceiveHeaderWithoutReturnType(this.apigen, a, mb);
        ReceiveSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    private void makeAsyncMethod(IOAction a, EndpointState succ, String futureClass) {
        String ROLE_PARAM = "role";
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        MethodBuilder mb = this.cb.newMethod("async");
        mb.addModifiers("public");
        this.setNextSocketReturnType(mb, succ);
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException");
        mb.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(a.obj)) + " " + "role");
        mb.addParameters(String.valueOf(opClass) + " " + "op");
        mb.addParameters("org.scribble.net.Buf<" + futureClass + "> " + "arg");
        mb.addBodyLine("arg.val = new " + futureClass + "(" + "super" + ".getFuture(" + this.getSessionApiRoleConstant(a.obj) + "));");
        this.addReturnNextSocket(mb, succ);
    }

    private void makeAsyncDiscardMethod(IOAction a, EndpointState succ, String futureClass) {
        MethodBuilder mb = this.makeAsyncDiscardHeader(a, succ, futureClass);
        mb.addBodyLine("return async(" + SessionApiGenerator.getSessionClassName(this.apigen.getGProtocolName()) + "." + a.obj + ", " + "op" + ", " + this.getGarbageBuf(futureClass) + ");");
        mb.addAnnotations("@SuppressWarnings(\"unchecked\")");
    }

    private MethodBuilder makeAsyncDiscardHeader(IOAction a, EndpointState succ, String futureClass) {
        MethodBuilder mb = this.cb.newMethod();
        ReceiveSocketGenerator.setAsyncDiscardHeaderWithoutReturnType(this.apigen, a, mb, futureClass);
        ReceiveSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    private void makeIsDoneMethod(IOAction a) {
        MethodBuilder mb = this.cb.newMethod("isDone");
        mb.addModifiers("public");
        mb.setReturn("boolean");
        mb.addBodyLine("return super.isDone(" + this.getSessionApiRoleConstant(a.obj) + ");");
    }

    public static void setReceiveHeaderWithoutReturnType(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb) throws ScribbleException {
        String ROLE_PARAM = "role";
        Module main = apigen.getMainModule();
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        mb.setName("receive");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        mb.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(a.obj)) + " " + "role", String.valueOf(opClass) + " " + "op");
        if (a.mid.isOp()) {
            ReceiveSocketGenerator.addReceiveOpParams(mb, main, a, true);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            ReceiveSocketGenerator.addReceiveMessageSigNameParams(mb, msd, true);
        }
    }

    protected static void addReceiveOpParams(MethodBuilder mb, Module main, IOAction a, boolean superr) throws ScribbleException {
        if (!a.payload.isEmpty()) {
            String buffSuper = "org.scribble.net.Buf<" + (superr ? "? super " : "");
            int i = 1;
            for (PayloadType<? extends PayloadTypeKind> pt : a.payload.elems) {
                if (!pt.isDataType()) {
                    throw new ScribbleException("[TODO] API generation not supported for non- data type payloads: " + pt);
                }
                DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                ScribSocketGenerator.checkJavaDataTypeDecl(dtd);
                mb.addParameters(String.valueOf(buffSuper) + dtd.extName + "> " + "arg" + i++);
            }
        }
    }

    protected static void addPayloadBuffSetters(Module main, IOAction a, MethodBuilder mb) {
        if (!a.payload.isEmpty()) {
            int i = 1;
            for (PayloadType<? extends PayloadTypeKind> pt : a.payload.elems) {
                DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                mb.addBodyLine("arg" + i + "." + "val" + " = (" + dtd.extName + ") " + "m" + "." + "payload" + "[" + (i++ - 1) + "];");
            }
        }
    }

    protected static void addReceiveMessageSigNameParams(MethodBuilder mb, MessageSigNameDecl msd, boolean superr) throws ScribbleException {
        ScribSocketGenerator.checkMessageSigNameDecl(msd);
        mb.addParameters("org.scribble.net.Buf<" + (superr ? "? super " : "") + msd.extName + "> " + "arg");
    }

    public static void setAsyncDiscardHeaderWithoutReturnType(StateChannelApiGenerator apigen, IOAction a, MethodBuilder mb, String futureClass) {
        String ROLE_PARAM = "role";
        String opClass = SessionApiGenerator.getOpClassName(a.mid);
        mb.setName("async");
        mb.addModifiers("public");
        mb.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(a.obj)) + " " + "role", String.valueOf(opClass) + " " + "op");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException");
    }
}

