/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelTypeGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.ConstructorBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Role;

public abstract class ScribSocketGenerator
extends StateChannelTypeGenerator {
    public static final String JAVA_SCHEMA = "java";
    public static final String SESSIONENDPOINT_CLASS = "org.scribble.net.session.SessionEndpoint";
    public static final String BUF_CLASS = "org.scribble.net.Buf";
    public static final String OPENUM_INTERFACE = "org.scribble.net.session.OpEnum";
    public static final String ACCEPTSOCKET_CLASS = "org.scribble.net.scribsock.AcceptSocket";
    public static final String OUTPUTSOCKET_CLASS = "org.scribble.net.scribsock.OutputSocket";
    public static final String RECEIVESOCKET_CLASS = "org.scribble.net.scribsock.ReceiveSocket";
    public static final String BRANCHSOCKET_CLASS = "org.scribble.net.scribsock.BranchSocket";
    public static final String CASESOCKET_CLASS = "org.scribble.net.scribsock.CaseSocket";
    public static final String ENDSOCKET_CLASS = "org.scribble.net.scribsock.EndSocket";
    public static final String SCRIBSERVERSOCKET_CLASS = "org.scribble.net.scribsock.ScribServerSocket";
    public static final String GENERATED_ENDSOCKET_NAME = "EndSocket";
    public static final String BUFF_VAL_FIELD = "val";
    public static final String SCRIBSOCKET_SE_FIELD = "this.se";
    public static final String SCRIBMESSAGE_PAYLOAD_FIELD = "payload";
    public static final String RECEIVE_MESSAGE_PARAM = "m";
    public static final String RECEIVE_ARG_PREFIX = "arg";
    public static final String CASE_OP_FIELD = "op";
    public static final String CASE_OP_PARAM = "op";
    public static final String CASE_MESSAGE_FIELD = "m";
    public static final String CASE_MESSAGE_PARAM = "m";
    public static final String CASE_ARG_PREFIX = "arg";
    protected final EndpointState curr;
    protected final String className;
    protected final ClassBuilder cb = new ClassBuilder();

    public ScribSocketGenerator(StateChannelApiGenerator apigen, EndpointState curr) {
        super(apigen);
        this.curr = curr;
        this.className = this.getClassName();
    }

    protected String getClassName() {
        return this.apigen.getSocketClassName(this.curr);
    }

    @Override
    public ClassBuilder generateType() throws ScribbleException {
        this.constructClass();
        return this.cb;
    }

    protected void constructClass() throws ScribbleException {
        this.constructClassExceptMethods();
        this.addMethods();
    }

    protected void constructClassExceptMethods() {
        this.cb.setName(this.className);
        this.cb.setPackage(this.getStateChannelPackageName());
        this.cb.addModifiers("public", "final");
        this.cb.setSuperClass(this.getSuperClassType());
        this.addImports();
        this.addConstructor();
        FieldBuilder cast = this.cb.newField("cast");
        cast.addModifiers("public", "static", "final");
        cast.setType(this.className);
        cast.setExpression("null");
    }

    protected abstract String getSuperClassType();

    protected void addImports() {
        this.cb.addImports(String.valueOf(this.getEndpointApiRootPackageName()) + ".*");
        this.cb.addImports(String.valueOf(this.getRolesPackageName()) + ".*");
    }

    protected MethodBuilder addConstructor() {
        String SESSIONENDPOINT_PARAM = "se";
        String sess = this.getSessionClassName();
        String role = this.getSelfClassName();
        ConstructorBuilder ctor = this.cb.newConstructor("org.scribble.net.session.SessionEndpoint<" + sess + ", " + role + "> " + "se", "boolean dummy");
        ctor.addModifiers("protected");
        ctor.addBodyLine("super(se);");
        if (this.curr.equals(this.apigen.getInitialState())) {
            this.addInitialStateConstructor();
        }
        return ctor;
    }

    protected void addInitialStateConstructor() {
        String SESSIONENDPOINT_PARAM = "se";
        String sess = this.getSessionClassName();
        String role = this.getSelfClassName();
        ConstructorBuilder ctor2 = this.cb.newConstructor("org.scribble.net.session.SessionEndpoint<" + sess + ", " + role + "> " + "se");
        ctor2.addExceptions("org.scribble.main.ScribbleRuntimeException");
        ctor2.addModifiers("public");
        ctor2.addBodyLine("super(se);");
        ctor2.addBodyLine("se.init();");
    }

    protected abstract void addMethods() throws ScribbleException;

    @Deprecated
    protected void setNextSocketReturnType(MethodBuilder mb, EndpointState succ) {
        ScribSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
    }

    protected void addReturnNextSocket(MethodBuilder mb, EndpointState s) {
        String nextClass;
        if (s.isTerminal()) {
            mb.addBodyLine("this.se.setCompleted();");
            nextClass = GENERATED_ENDSOCKET_NAME;
        } else {
            nextClass = this.apigen.getSocketClassName(s);
        }
        mb.addBodyLine("return new " + nextClass + "(" + SCRIBSOCKET_SE_FIELD + ", true);");
    }

    protected String getGarbageBuf(String futureClass) {
        return "(org.scribble.net.Buf<" + futureClass + ">) " + SCRIBSOCKET_SE_FIELD + ".gc";
    }

    protected String getSessionApiRoleConstant(Role role) {
        return String.valueOf(SessionApiGenerator.getSessionClassName(this.apigen.getGProtocolName())) + "." + role;
    }

    protected String getSessionApiOpConstant(MessageId<?> mid) {
        return String.valueOf(SessionApiGenerator.getSessionClassName(this.apigen.getGProtocolName())) + "." + SessionApiGenerator.getOpClassName(mid);
    }

    protected String getSessionClassName() {
        return SessionApiGenerator.getSessionClassName(this.apigen.getGProtocolName());
    }

    protected String getSelfClassName() {
        return SessionApiGenerator.getRoleClassName(this.apigen.getSelf());
    }

    protected String getEndpointApiRootPackageName() {
        return SessionApiGenerator.getEndpointApiRootPackageName(this.apigen.getGProtocolName());
    }

    protected String getRolesPackageName() {
        return SessionApiGenerator.getRolesPackageName(this.apigen.getGProtocolName());
    }

    protected String getOpsPackageName() {
        return SessionApiGenerator.getOpsPackageName(this.apigen.getGProtocolName());
    }

    protected String getStateChannelPackageName() {
        return SessionApiGenerator.getStateChannelPackageName(this.apigen.getGProtocolName(), this.apigen.getSelf());
    }

    public static void setNextSocketReturnType(StateChannelApiGenerator apigen, MethodBuilder mb, EndpointState succ) {
        String ret;
        if (succ.isTerminal()) {
            GProtocolName gpn = apigen.getGProtocolName();
            Role self = apigen.getSelf();
            ret = String.valueOf(SessionApiGenerator.getStateChannelPackageName(gpn, self)) + "." + GENERATED_ENDSOCKET_NAME;
        } else {
            ret = apigen.getSocketClassName(succ);
        }
        mb.setReturn(ret);
    }

    protected static void checkJavaDataTypeDecl(DataTypeDecl dtd) throws ScribbleException {
        ScribSocketGenerator.checkJavaSchema(dtd.schema);
    }

    protected static void checkMessageSigNameDecl(MessageSigNameDecl msd) throws ScribbleException {
        ScribSocketGenerator.checkJavaSchema(msd.schema);
    }

    protected static void checkJavaSchema(String schema) throws ScribbleException {
        if (!schema.equals(JAVA_SCHEMA)) {
            throw new ScribbleException("Unexpected data type schema: " + schema);
        }
    }
}

