/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.AcceptSocketGenerator;
import org.scribble.codegen.java.endpointapi.ApiGenerator;
import org.scribble.codegen.java.endpointapi.BranchSocketGenerator;
import org.scribble.codegen.java.endpointapi.EndSocketGenerator;
import org.scribble.codegen.java.endpointapi.OutputSocketGenerator;
import org.scribble.codegen.java.endpointapi.ReceiveSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.TypeBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.Job;
import org.scribble.visit.JobContext;
import org.scribble.visit.Projector;

public class StateChannelApiGenerator
extends ApiGenerator {
    public static final String SCRIBMESSAGE_CLASS = "org.scribble.net.ScribMessage";
    public static final String SCRIBBLERUNTIMEEXCEPTION_CLASS = "org.scribble.main.ScribbleRuntimeException";
    public static final String RECEIVE_OP_PARAM = "op";
    public static final String SCRIBMESSAGE_OP_FIELD = "op";
    private final Role self;
    private final LProtocolName lpn;
    private final EndpointState init;
    protected final boolean skipIOInterfacesGeneration;
    private int counter = 1;
    private Map<EndpointState, String> classNames = new HashMap<EndpointState, String>();
    private Map<String, TypeBuilder> types = new HashMap<String, TypeBuilder>();

    public StateChannelApiGenerator(Job job, GProtocolName fullname, Role self) throws ScribbleException {
        super(job, fullname);
        this.self = self;
        this.lpn = Projector.projectFullProtocolName(fullname, self);
        JobContext jc = job.getContext();
        this.init = job.minEfsm ? jc.getMinimisedEndpointGraph((GProtocolName)fullname, (Role)self).init : jc.getEndpointGraph((GProtocolName)fullname, (Role)self).init;
        this.skipIOInterfacesGeneration = StateChannelApiGenerator.skipIOInterfacesGeneration(this.init);
        this.generateClassNames(this.init);
        this.constructClasses(this.init);
        EndpointState term = EndpointState.getTerminal(this.init);
        if (term != null) {
            ClassBuilder cb = new EndSocketGenerator(this, term).generateType();
            this.types.put(cb.getName(), cb);
        }
    }

    private static boolean skipIOInterfacesGeneration(EndpointState init) {
        Set<IOAction> as = EndpointState.getAllReachableActions(init);
        return as.stream().anyMatch(a -> !a.isSend() && !a.isReceive());
    }

    @Override
    public Map<String, String> generateApi() {
        HashMap<String, String> map = new HashMap<String, String>();
        String prefix = String.valueOf(SessionApiGenerator.getEndpointApiRootPackageName(this.gpn).replace('.', '/')) + "/channels/" + this.self + "/";
        for (String s : this.types.keySet()) {
            String path = String.valueOf(prefix) + s + ".java";
            map.put(path, this.types.get(s).build());
        }
        return map;
    }

    private void generateClassNames(EndpointState ps) {
        if (this.classNames.containsKey(ps)) {
            return;
        }
        if (ps.isTerminal()) {
            return;
        }
        this.classNames.put(ps, this.newSocketClassName());
        for (EndpointState succ : ps.getSuccessors()) {
            this.generateClassNames(succ);
        }
    }

    private String newSocketClassName() {
        return String.valueOf(this.lpn.getSimpleName().toString()) + "_" + this.counter++;
    }

    private void constructClasses(EndpointState curr) throws ScribbleException {
        if (curr.isTerminal()) {
            return;
        }
        String className = this.classNames.get(curr);
        if (this.types.containsKey(className)) {
            return;
        }
        this.types.put(className, this.constructClass(curr));
        for (EndpointState succ : curr.getSuccessors()) {
            this.constructClasses(succ);
        }
    }

    private ClassBuilder constructClass(EndpointState curr) throws ScribbleException {
        switch (curr.getStateKind()) {
            case OUTPUT: {
                return new OutputSocketGenerator(this, curr).generateType();
            }
            case ACCEPT: {
                return new AcceptSocketGenerator(this, curr).generateType();
            }
            case UNARY_INPUT: {
                return new ReceiveSocketGenerator(this, curr).generateType();
            }
            case POLY_INPUT: {
                return new BranchSocketGenerator(this, curr).generateType();
            }
        }
        throw new RuntimeException("[TODO] State Channel API generation not supported for: " + (Object)((Object)curr.getStateKind()) + ", " + curr.toLongString());
    }

    public GProtocolName getGProtocolName() {
        return this.gpn;
    }

    public Role getSelf() {
        return this.self;
    }

    protected EndpointState getInitialState() {
        return this.init;
    }

    protected Module getMainModule() {
        return this.job.getContext().getMainModule();
    }

    protected void addTypeDecl(TypeBuilder tb) {
        this.types.put(tb.getName(), tb);
    }

    public String getSocketClassName(EndpointState s) {
        return this.classNames.get(s);
    }

    public TypeBuilder getType(String key) {
        return this.types.get(key);
    }
}

