/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.CaseInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.HandleInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.EnumBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.Role;

public class BranchInterfaceGenerator
extends IOStateInterfaceGenerator {
    public BranchInterfaceGenerator(StateChannelApiGenerator apigen, Map<IOAction, InterfaceBuilder> actions, EndpointState curr) {
        super(apigen, actions, curr);
    }

    @Override
    protected void constructInterface() throws ScribbleException {
        super.constructInterface();
        this.addBranchEnum();
        this.addBranchMethods();
    }

    protected void addBranchMethods() {
        Role self = this.apigen.getSelf();
        Set as = this.curr.getTakeable();
        AbstractMethodBuilder bra = this.ib.newAbstractMethod("branch");
        String ret = String.valueOf(CaseInterfaceGenerator.getCasesInterfaceName(self, this.curr)) + "<" + IntStream.range(1, as.size() + 1).mapToObj(i -> "__Succ" + i).collect(Collectors.joining(", ")) + ">";
        bra.setReturn(ret);
        bra.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(((IOAction)as.iterator().next()).obj)) + " role");
        bra.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        AbstractMethodBuilder bra2 = this.ib.newAbstractMethod("branch");
        bra2.setReturn("void");
        bra2.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(((IOAction)as.iterator().next()).obj)) + " role");
        String next = String.valueOf(HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr)) + "<" + IntStream.range(1, as.size() + 1).mapToObj(i -> "__Succ" + i).collect(Collectors.joining(", ")) + ">";
        bra2.addParameters(String.valueOf(next) + " handler");
        bra2.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        AbstractMethodBuilder bra3 = this.ib.newAbstractMethod("handle");
        bra3.setReturn("void");
        bra3.addParameters(String.valueOf(SessionApiGenerator.getRoleClassName(((IOAction)as.iterator().next()).obj)) + " role");
        String handle = String.valueOf(HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr)) + "<" + as.stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).map(a -> SuccessorInterfaceGenerator.getSuccessorInterfaceName(a)).collect(Collectors.joining(", ")) + ">";
        bra3.addParameters(String.valueOf(handle) + " handler");
        bra3.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
    }

    protected void addBranchEnum() {
        Role self = this.apigen.getSelf();
        EnumBuilder eb = this.ib.newMemberEnum(BranchInterfaceGenerator.getBranchInterfaceEnumName(self, this.curr));
        eb.addModifiers("public");
        eb.addInterfaces("org.scribble.net.session.OpEnum");
        this.curr.getTakeable().stream().forEach(a -> eb.addValues(SessionApiGenerator.getOpClassName(a.mid)));
    }

    @Override
    protected void addSuccessorParamsAndActionInterfaces() {
        int i = 1;
        for (IOAction a : this.curr.getTakeable().stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            this.ib.addParameters("__Succ" + i + " extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
            ++i;
        }
    }

    public static String getBranchInterfaceEnumName(Role self, EndpointState curr) {
        return String.valueOf(BranchInterfaceGenerator.getIOStateInterfaceName(self, curr)) + "_Enum";
    }
}

