/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.codegen.java.endpointapi.HandlerInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.ActionInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public class HandleInterfaceGenerator
extends IOStateInterfaceGenerator {
    private final Map<IOAction, InterfaceBuilder> caseActions;

    public HandleInterfaceGenerator(IOInterfacesGenerator iogen, Map<IOAction, InterfaceBuilder> actions, EndpointState curr, Map<IOAction, InterfaceBuilder> caseActions) {
        super(iogen.apigen, actions, curr);
        this.caseActions = caseActions;
    }

    @Override
    protected void constructInterface() throws ScribbleException {
        super.constructInterface();
        this.addHandleMethods();
    }

    @Override
    protected void addHeader() {
        GProtocolName gpn = this.apigen.getGProtocolName();
        Role self = this.apigen.getSelf();
        String packname = IOInterfacesGenerator.getIOInterfacePackageName(gpn, self);
        String ifname = HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr);
        this.ib.setName(ifname);
        this.ib.setPackage(packname);
        this.ib.addModifiers("public");
    }

    @Override
    protected void addCastField() {
    }

    @Override
    protected void addSuccessorParamsAndActionInterfaces() {
        int i = 1;
        for (IOAction a : this.curr.getTakeable().stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            this.ib.addParameters("__Succ" + i + " extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
            this.ib.addInterfaces(String.valueOf(this.caseActions.get(a).getName()) + "<__Succ" + i + ">");
            ++i;
        }
    }

    protected void addHandleMethods() throws ScribbleException {
        GProtocolName gpn = this.apigen.getGProtocolName();
        Set as = this.curr.getTakeable();
        this.ib.addImports(String.valueOf(SessionApiGenerator.getOpsPackageName(gpn)) + ".*");
        int i = 1;
        for (IOAction a : as.stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            AbstractMethodBuilder mb = this.ib.newAbstractMethod();
            HandlerInterfaceGenerator.setHandleMethodHeaderWithoutParamTypes(this.apigen, mb);
            mb.addParameters("__Succ" + i++ + " schan");
            HandlerInterfaceGenerator.addHandleMethodOpAndPayloadParams(this.apigen, a, mb);
        }
    }

    protected static void setHandleMethodSuccessorParam(IOInterfacesGenerator iogen, Role self, EndpointState succ, MethodBuilder mb, List<IOAction> as, Map<IOAction, Integer> count) {
        if (succ.isTerminal()) {
            mb.addParameters("org.scribble.net.scribsock.EndSocket<?, ?> end");
        } else {
            InterfaceBuilder next = iogen.getIOStateInterface(IOStateInterfaceGenerator.getIOStateInterfaceName(self, succ));
            String ret = String.valueOf(next.getName()) + "<";
            boolean first = true;
            for (IOAction a : succ.getTakeable().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList())) {
                int offset;
                if (!count.containsKey(a)) {
                    offset = 0;
                    count.put(a, 0);
                } else {
                    offset = count.get(a) + 1;
                    count.put(a, offset);
                }
                if (first) {
                    first = false;
                } else {
                    ret = String.valueOf(ret) + ", ";
                }
                ret = String.valueOf(ret) + "__Succ" + (as.indexOf(a) + 1 + offset);
            }
            ret = String.valueOf(ret) + ">";
            mb.addParameters(String.valueOf(ret) + " schan");
        }
    }

    public static String getHandleInterfaceName(Role self, EndpointState s) {
        String name = "Handle_" + self + "_" + s.getTakeable().stream().sorted(IOACTION_COMPARATOR).map(a -> ActionInterfaceGenerator.getActionString(a)).collect(Collectors.joining("__"));
        IOStateInterfaceGenerator.checkIOStateInterfaceNameLength(name);
        return name;
    }
}

