/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.ActionInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public abstract class IOStateInterfaceGenerator
extends IOInterfaceGenerator {
    public static final Comparator<IOAction> IOACTION_COMPARATOR = new Comparator<IOAction>(){

        @Override
        public int compare(IOAction a1, IOAction a2) {
            return ActionInterfaceGenerator.getActionInterfaceName(a1).compareTo(ActionInterfaceGenerator.getActionInterfaceName(a2));
        }
    };
    protected final Map<IOAction, InterfaceBuilder> actions;
    protected final InterfaceBuilder ib = new InterfaceBuilder();

    public IOStateInterfaceGenerator(StateChannelApiGenerator apigen, Map<IOAction, InterfaceBuilder> actions, EndpointState curr) {
        super(apigen, curr);
        this.actions = Collections.unmodifiableMap(actions);
    }

    @Override
    public InterfaceBuilder generateType() throws ScribbleException {
        this.constructInterface();
        return this.ib;
    }

    protected void constructInterface() throws ScribbleException {
        this.addHeader();
        this.addSuccessorParamsAndActionInterfaces();
        this.addCastField();
    }

    protected void addHeader() {
        GProtocolName gpn = this.apigen.getGProtocolName();
        Role self = this.apigen.getSelf();
        String packname = IOInterfacesGenerator.getIOInterfacePackageName(gpn, self);
        String ifname = IOStateInterfaceGenerator.getIOStateInterfaceName(self, this.curr);
        this.ib.setName(ifname);
        this.ib.setPackage(packname);
        this.ib.addImports(String.valueOf(SessionApiGenerator.getRolesPackageName(gpn)) + ".*");
        this.ib.addModifiers("public");
    }

    protected void addCastField() {
        String ifname = IOStateInterfaceGenerator.getIOStateInterfaceName(this.apigen.getSelf(), this.curr);
        Set as = this.curr.getTakeable();
        FieldBuilder cast = this.ib.newField("cast");
        cast.addModifiers("public", "static", "final");
        cast.setType(String.valueOf(ifname) + "<" + IntStream.range(1, as.size() + 1).mapToObj(i -> "?").collect(Collectors.joining(", ")) + ">");
        cast.setExpression("null");
    }

    protected void addSuccessorParamsAndActionInterfaces() {
        int i = 1;
        for (IOAction a : this.curr.getTakeable().stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            if (!a.isSend() && !a.isReceive()) continue;
            String actif = this.actions.get(a).getName();
            this.ib.addParameters("__Succ" + i + " extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
            this.ib.addInterfaces(String.valueOf(actif) + "<__Succ" + i + ">");
            ++i;
        }
    }

    public static String getIOStateInterfaceName(Role self, EndpointState s) {
        String name = null;
        switch (s.getStateKind()) {
            case OUTPUT: {
                name = "Select";
                break;
            }
            case UNARY_INPUT: {
                name = "Receive";
                break;
            }
            case POLY_INPUT: {
                name = "Branch";
                break;
            }
            case TERMINAL: {
                throw new RuntimeScribbleException("Shouldn't get in here: " + s);
            }
            default: {
                throw new RuntimeException("(TODO) I/O interface generation: " + (Object)((Object)s.getStateKind()));
            }
        }
        name = String.valueOf(name) + "_" + self + "_" + s.getTakeable().stream().sorted(IOACTION_COMPARATOR).map(a -> ActionInterfaceGenerator.getActionString(a)).collect(Collectors.joining("__"));
        IOStateInterfaceGenerator.checkIOStateInterfaceNameLength(name);
        return name;
    }

    public static void checkIOStateInterfaceNameLength(String name) throws RuntimeScribbleException {
        if (name.length() > 250) {
            throw new RuntimeScribbleException("I/O Interface name too long (max 255): " + name);
        }
    }
}

