/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.scribble.codegen.java.util.JavaBuilder;

public class MethodBuilder
extends JavaBuilder {
    private final List<String> annots = new LinkedList<String>();
    private final List<String> mods = new LinkedList<String>();
    private String ret;
    private final List<String> pars = new LinkedList<String>();
    private final List<String> exceptions = new LinkedList<String>();
    private final List<String> body = new LinkedList<String>();

    protected MethodBuilder() {
    }

    protected MethodBuilder(String name) {
        super(name);
    }

    public void addAnnotations(String ... mods) {
        this.annots.addAll(Arrays.asList(mods));
    }

    public void addModifiers(String ... mods) {
        this.mods.addAll(Arrays.asList(mods));
    }

    public void setReturn(String ret) {
        this.setterCheck(this.ret);
        this.ret = ret;
    }

    public String getReturn() {
        return this.ret;
    }

    public void addParameters(String ... par) {
        this.pars.addAll(Arrays.asList(par));
    }

    public List<String> getParameters() {
        return this.pars;
    }

    public void addExceptions(String ... exceptions) {
        this.exceptions.addAll(Arrays.asList(exceptions));
    }

    public void addBodyLine(String ln) {
        this.body.add(ln);
    }

    public final void addBodyLine(int i, String ln) {
        int j = 0;
        while (j < i) {
            ln = "\t" + ln;
            ++j;
        }
        this.addBodyLine(ln);
    }

    @Override
    public String build() {
        String meth = "";
        meth = this.buildSignature(meth);
        meth = this.buildBody(meth);
        return meth;
    }

    protected String buildSignature(String meth) {
        if (!this.annots.isEmpty()) {
            meth = String.valueOf(meth) + "\t";
            meth = String.valueOf(meth) + this.annots.stream().collect(Collectors.joining("\n\t")) + "\n";
        }
        meth = String.valueOf(meth) + "\t";
        if (!this.mods.isEmpty()) {
            meth = String.valueOf(meth) + this.mods.stream().collect(Collectors.joining(" "));
            meth = String.valueOf(meth) + " ";
        }
        if (this.ret != null) {
            meth = String.valueOf(meth) + this.ret + " ";
        }
        meth = String.valueOf(meth) + this.name + "(";
        meth = String.valueOf(meth) + this.pars.stream().collect(Collectors.joining(", "));
        meth = String.valueOf(meth) + ")";
        if (!this.exceptions.isEmpty()) {
            meth = String.valueOf(meth) + " throws " + this.exceptions.stream().collect(Collectors.joining(", "));
        }
        return meth;
    }

    protected String buildBody(String meth) {
        meth = String.valueOf(meth) + " {\n";
        if (!this.body.isEmpty()) {
            meth = String.valueOf(meth) + "\t\t";
            meth = String.valueOf(meth) + this.body.stream().collect(Collectors.joining("\n\t\t"));
        }
        meth = String.valueOf(meth) + "\n\t}";
        return meth;
    }
}

