/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.EnumBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.JavaBuilder;
import org.scribble.codegen.java.util.MethodBuilder;

public abstract class TypeBuilder
extends JavaBuilder {
    protected String packname;
    protected final LinkedHashSet<String> imports = new LinkedHashSet();
    protected final LinkedHashSet<String> mods = new LinkedHashSet();
    protected final LinkedHashSet<String> ifaces = new LinkedHashSet();
    protected final List<String> params = new LinkedList<String>();
    protected final List<FieldBuilder> fields = new LinkedList<FieldBuilder>();
    protected final List<MethodBuilder> methods = new LinkedList<MethodBuilder>();
    protected final List<TypeBuilder> topLevelTypes = new LinkedList<TypeBuilder>();
    protected final List<TypeBuilder> memberTypes = new LinkedList<TypeBuilder>();

    public TypeBuilder() {
    }

    public TypeBuilder(String name) {
        super(name);
    }

    public void setPackage(String packname) {
        this.setterCheck(this.packname);
        this.packname = packname;
    }

    public void addImports(String ... imports) {
        this.imports.addAll(Arrays.asList(imports));
    }

    public void addModifiers(String ... mods) {
        this.mods.addAll(Arrays.asList(mods));
    }

    public void addInterfaces(String ... ifaces) {
        this.ifaces.addAll(Arrays.asList(ifaces));
    }

    public List<String> getInterfaces() {
        return new LinkedList<String>(this.ifaces);
    }

    public void addParameters(String ... params) {
        this.params.addAll(Arrays.asList(params));
    }

    public List<String> getParameters() {
        return this.params;
    }

    public FieldBuilder newField(String name) {
        FieldBuilder fb = new FieldBuilder();
        fb.setName(name);
        this.fields.add(fb);
        return fb;
    }

    public AbstractMethodBuilder newAbstractMethod() {
        AbstractMethodBuilder mb = new AbstractMethodBuilder();
        this.methods.add(mb);
        return mb;
    }

    public final AbstractMethodBuilder newAbstractMethod(String name) {
        AbstractMethodBuilder mb = this.newAbstractMethod();
        mb.setName(name);
        return mb;
    }

    public final void checkDuplicateMethods(MethodBuilder mb) {
        LinkedList<MethodBuilder> toRemove = new LinkedList<MethodBuilder>();
        block0: for (MethodBuilder tmp : this.methods) {
            if (tmp.equals(mb) || !tmp.getReturn().equals(mb.getReturn())) continue;
            if (tmp.getParameters().size() == 0) {
                if (mb.getParameters().size() != 0) {
                    continue;
                }
            } else {
                Iterator<String> mbparams = mb.getParameters().iterator();
                for (String tmpparam : tmp.getParameters()) {
                    if (!mbparams.hasNext()) continue block0;
                    String mbparam = mbparams.next();
                    mbparam = mbparam.contains("<") ? mbparam.substring(0, mbparam.indexOf("<")) : mbparam.substring(0, mbparam.indexOf(" "));
                    if (!(tmpparam = tmpparam.contains("<") ? tmpparam.substring(0, tmpparam.indexOf("<")) : tmpparam.substring(0, tmpparam.indexOf(" "))).equals(mbparam)) continue block0;
                }
            }
            toRemove.add(mb);
        }
        this.methods.removeAll(toRemove);
    }

    public EnumBuilder newMemberEnum(String name) {
        EnumBuilder eb = new EnumBuilder();
        eb.setName(name);
        this.memberTypes.add(eb);
        return eb;
    }

    public ClassBuilder newTopLevelClass() {
        ClassBuilder cb = new ClassBuilder();
        this.topLevelTypes.add(cb);
        return cb;
    }

    @Override
    public String build() {
        String clazz = "";
        clazz = this.buildHeader(clazz);
        clazz = this.buildSignature(clazz);
        clazz = this.buildBody(clazz);
        clazz = this.buildTopLevelTypes(clazz);
        return clazz;
    }

    protected String buildBody(String clazz) {
        clazz = String.valueOf(clazz) + " {";
        clazz = this.buildFields(clazz);
        clazz = this.buildMethods(clazz);
        clazz = this.buildMemberTypes(clazz);
        clazz = String.valueOf(clazz) + "\n}";
        return clazz;
    }

    protected String buildHeader(String clazz) {
        if (this.packname != null) {
            clazz = String.valueOf(clazz) + "package " + this.packname + ";";
        }
        if (!this.imports.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n\nimport ";
            clazz = String.valueOf(clazz) + this.imports.stream().collect(Collectors.joining(";\nimport "));
            clazz = String.valueOf(clazz) + ";";
        }
        if (this.packname != null || !this.imports.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n\n";
        }
        return clazz;
    }

    protected abstract String buildSignature(String var1);

    protected String buildFields(String clazz) {
        if (!this.fields.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n";
            clazz = String.valueOf(clazz) + this.fields.stream().map(fb -> fb.build()).collect(Collectors.joining("\n"));
        }
        return clazz;
    }

    protected String buildMethods(String clazz) {
        if (!this.methods.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n\n";
            clazz = String.valueOf(clazz) + this.methods.stream().map(mb -> mb.build()).collect(Collectors.joining("\n\n"));
        }
        return clazz;
    }

    protected String buildMemberTypes(String clazz) {
        if (!this.memberTypes.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n\n";
            clazz = String.valueOf(clazz) + this.memberTypes.stream().map(cb -> cb.build()).collect(Collectors.joining("\n\n"));
        }
        return clazz;
    }

    protected String buildTopLevelTypes(String clazz) {
        if (!this.topLevelTypes.isEmpty()) {
            clazz = String.valueOf(clazz) + "\n\n";
            clazz = String.valueOf(clazz) + this.topLevelTypes.stream().map(cb -> cb.build()).collect(Collectors.joining("\n\n"));
        }
        return clazz;
    }
}

