/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.Module;
import org.scribble.ast.ModuleDecl;
import org.scribble.ast.NonProtocolDecl;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.context.ModuleContext;
import org.scribble.ast.local.LProtocolDecl;
import org.scribble.ast.name.qualified.ModuleNameNode;
import org.scribble.del.ScribDelBase;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.AbstractName;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.LProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.ModuleContextBuilder;
import org.scribble.visit.NameDisambiguator;
import org.scribble.visit.Projector;

public class ModuleDel
extends ScribDelBase {
    private ModuleContext mcontext;

    private ModuleDel copy() {
        return new ModuleDel();
    }

    @Override
    public void enterModuleContextBuilding(ScribNode parent, ScribNode child, ModuleContextBuilder builder) throws ScribbleException {
        builder.setModuleContext(new ModuleContext(builder.getJobContext(), (Module)child));
    }

    @Override
    public Module leaveModuleContextBuilding(ScribNode parent, ScribNode child, ModuleContextBuilder builder, ScribNode visited) throws ScribbleException {
        ModuleDel del = this.setModuleContext(builder.getModuleContext());
        return (Module)visited.del(del);
    }

    @Override
    public Module leaveDisambiguation(ScribNode parent, ScribNode child, NameDisambiguator disamb, ScribNode visited) throws ScribbleException {
        Module mod = (Module)visited;
        List<NonProtocolDecl<?>> npds = mod.getNonProtocolDecls();
        List<String> npdnames = npds.stream().map(npd -> ((AbstractName)npd.getDeclName()).toString()).collect(Collectors.toList());
        Set<String> dups = ModuleDel.getDuplicates(npdnames);
        if (!dups.isEmpty()) {
            throw new ScribbleException("Duplicate non-protocol decls: " + dups);
        }
        List<ProtocolDecl<?>> pds = mod.getProtocolDecls();
        List<String> pdnames = pds.stream().map(pd -> ((AbstractName)pd.header.getDeclName()).toString()).collect(Collectors.toList());
        dups = ModuleDel.getDuplicates(pdnames);
        if ((long)pds.size() != pdnames.stream().distinct().count() && !dups.isEmpty()) {
            throw new ScribbleException("Duplicate protocol decls: " + dups);
        }
        return mod;
    }

    private static Set<String> getDuplicates(Collection<String> ss) {
        HashSet<String> uniques = new HashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        for (String npd : ss) {
            if (uniques.add(npd)) continue;
            dups.add(npd);
        }
        return dups;
    }

    @Override
    public Module leaveProjection(ScribNode parent, ScribNode child, Projector proj, ScribNode visited) {
        proj.getJobContext().addProjections(proj.getProjections());
        return (Module)visited;
    }

    public Module createModuleForProjection(Projector proj, Module root, LProtocolDecl lpd, Map<GProtocolName, Set<Role>> deps) {
        ModuleNameNode modname = Projector.makeProjectedModuleNameNode(root.moddecl.getFullModuleName(), lpd.getHeader().getDeclName());
        ModuleDecl moddecl = AstFactoryImpl.FACTORY.ModuleDecl(modname);
        LinkedList imports = new LinkedList();
        for (GProtocolName gpn : deps.keySet()) {
            for (Role role : deps.get(gpn)) {
                LProtocolName targetsimpname = Projector.projectSimpleProtocolName(gpn.getSimpleName(), role);
                ModuleNameNode targetmodname = Projector.makeProjectedModuleNameNode(gpn.getPrefix(), targetsimpname);
                if (targetmodname.toName().equals(modname.toName())) continue;
                imports.add(AstFactoryImpl.FACTORY.ImportModule(targetmodname, null));
            }
        }
        LinkedList data = new LinkedList(root.getNonProtocolDecls());
        List<ProtocolDecl<?>> protos = Arrays.asList(lpd);
        return AstFactoryImpl.FACTORY.Module(moddecl, imports, data, protos);
    }

    public String toString() {
        return this.mcontext == null ? null : this.mcontext.toString();
    }

    public ModuleContext getModuleContext() {
        return this.mcontext;
    }

    protected ModuleDel setModuleContext(ModuleContext mcontext) {
        ModuleDel copy = this.copy();
        copy.mcontext = mcontext;
        return copy;
    }
}

