/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del;

import org.scribble.ast.Recursion;
import org.scribble.ast.ScribNode;
import org.scribble.del.CompoundInteractionNodeDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.RecVar;
import org.scribble.visit.InlinedProtocolUnfolder;
import org.scribble.visit.NameDisambiguator;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.env.UnfoldingEnv;

public abstract class RecursionDel
extends CompoundInteractionNodeDel {
    @Override
    public void enterDisambiguation(ScribNode parent, ScribNode child, NameDisambiguator disamb) throws ScribbleException {
        Recursion rec = (Recursion)child;
        RecVar rv = rec.recvar.toName();
        disamb.pushRecVar(rv);
    }

    @Override
    public ScribNode leaveDisambiguation(ScribNode parent, ScribNode child, NameDisambiguator disamb, ScribNode visited) throws ScribbleException {
        Recursion rec = (Recursion)visited;
        RecVar rv = ((Recursion)child).recvar.toName();
        disamb.popRecVar(rv);
        return rec;
    }

    @Override
    public void enterProtocolInlining(ScribNode parent, ScribNode child, ProtocolDefInliner inliner) throws ScribbleException {
        super.enterProtocolInlining(parent, child, inliner);
        Recursion rec = (Recursion)child;
        inliner.pushRecVar(rec.recvar.toName());
    }

    @Override
    public ScribNode leaveProtocolInlining(ScribNode parent, ScribNode child, ProtocolDefInliner inliner, ScribNode visited) throws ScribbleException {
        RecVar origRV = ((Recursion)child).recvar.toName();
        inliner.popRecVar(origRV);
        return super.leaveProtocolInlining(parent, child, inliner, visited);
    }

    @Override
    public void enterInlinedProtocolUnfolding(ScribNode parent, ScribNode child, InlinedProtocolUnfolder unf) throws ScribbleException {
        super.enterInlinedProtocolUnfolding(parent, child, unf);
        Recursion lr = (Recursion)child;
        RecVar recvar = lr.recvar.toName();
        unf.setRecVar(recvar, lr);
    }

    @Override
    public Recursion<?> leaveInlinedProtocolUnfolding(ScribNode parent, ScribNode child, InlinedProtocolUnfolder unf, ScribNode visited) throws ScribbleException {
        Recursion rec = (Recursion)visited;
        RecVar recvar = rec.recvar.toName();
        unf.removeRecVar(recvar);
        UnfoldingEnv merged = ((UnfoldingEnv)unf.popEnv()).mergeContext((UnfoldingEnv)rec.block.del().env());
        unf.pushEnv(merged);
        return (Recursion)super.leaveInlinedProtocolUnfolding(parent, child, unf, rec);
    }
}

