/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del.global;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.ScribNode;
import org.scribble.ast.global.GChoice;
import org.scribble.ast.global.GProtocolBlock;
import org.scribble.ast.local.LChoice;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.del.ChoiceDel;
import org.scribble.del.global.GCompoundInteractionNodeDel;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.Projector;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.WFChoiceChecker;
import org.scribble.visit.env.Env;
import org.scribble.visit.env.InlineProtocolEnv;
import org.scribble.visit.env.ProjectionEnv;
import org.scribble.visit.env.WFChoiceEnv;

public class GChoiceDel
extends ChoiceDel
implements GCompoundInteractionNodeDel {
    @Override
    public ScribNode leaveProtocolInlining(ScribNode parent, ScribNode child, ProtocolDefInliner inl, ScribNode visited) throws ScribbleException {
        GChoice gc = (GChoice)visited;
        List<GProtocolBlock> blocks = gc.getBlocks().stream().map(b -> (GProtocolBlock)((InlineProtocolEnv)b.del().env()).getTranslation()).collect(Collectors.toList());
        RoleNode subj = gc.subj.clone();
        GChoice inlined = AstFactoryImpl.FACTORY.GChoice(subj, blocks);
        inl.pushEnv(((InlineProtocolEnv)inl.popEnv()).setTranslation(inlined));
        return (GChoice)super.leaveProtocolInlining(parent, child, inl, gc);
    }

    @Override
    public void enterInlinedWFChoiceCheck(ScribNode parent, ScribNode child, WFChoiceChecker checker) throws ScribbleException {
        WFChoiceEnv env = ((WFChoiceEnv)checker.peekEnv()).enterContext();
        env = env.clear();
        env = env.enableChoiceSubject(((GChoice)child).subj.toName());
        checker.pushEnv(env);
    }

    @Override
    public GChoice leaveInlinedWFChoiceCheck(ScribNode parent, ScribNode child, WFChoiceChecker checker, ScribNode visited) throws ScribbleException {
        GChoice cho = (GChoice)visited;
        Role subj = cho.subj.toName();
        if (!((WFChoiceEnv)checker.peekParentEnv()).isEnabled(subj)) {
            throw new ScribbleException("Subject not enabled: " + subj);
        }
        List all = cho.getBlocks().stream().map(b -> (WFChoiceEnv)b.del().env()).collect(Collectors.toList());
        if (checker.getJob().useOldWf && all.size() > 1) {
            try {
                WFChoiceEnv benv0 = (WFChoiceEnv)all.get(0);
                List benvs = all.subList(1, all.size());
                Set<Role> dests = benv0.getEnabled().getDestinations();
                benvs.stream().map(e -> e.getEnabled().getDestinations()).forEach(rs -> {
                    if (!dests.equals(rs)) {
                        throw new RuntimeScribbleException("Mismatched enabled roles: " + dests + ", " + rs);
                    }
                });
                dests.remove(subj);
                for (Role dest : dests) {
                    Set<Role> srcs = benv0.getEnabled().getSources(dest);
                    benvs.stream().map(e -> e.getEnabled().getSources(dest)).forEach(rs -> {
                        if (!srcs.equals(rs)) {
                            throw new RuntimeScribbleException("Mismatched enabler roles for " + dest + ": " + srcs + ", " + rs);
                        }
                    });
                    Set<MessageId<?>> mids = benv0.getEnabled().getMessages(dest);
                    benvs.stream().map(e -> e.getEnabled().getMessages(dest)).forEach(ms -> {
                        if (!Collections.disjoint(mids, ms)) {
                            throw new RuntimeScribbleException("Non disjoint enabling messages for " + dest + ": " + mids + ", " + ms);
                        }
                        mids.addAll((Collection<MessageId<?>>)ms);
                    });
                }
            }
            catch (RuntimeScribbleException rse) {
                throw new ScribbleException(rse.getMessage(), rse.getCause());
            }
        }
        Env merged = ((WFChoiceEnv)checker.popEnv()).mergeContexts(all);
        checker.pushEnv(merged);
        return (GChoice)super.leaveInlinedWFChoiceCheck(parent, child, checker, visited);
    }

    @Override
    public GChoice leaveProjection(ScribNode parent, ScribNode child, Projector proj, ScribNode visited) throws ScribbleException {
        GChoice gc = (GChoice)visited;
        List<LProtocolBlock> blocks = gc.getBlocks().stream().map(b -> (LProtocolBlock)((ProjectionEnv)b.del().env()).getProjection()).collect(Collectors.toList());
        LChoice projection = gc.project(proj.peekSelf(), blocks);
        proj.pushEnv(((ProjectionEnv)proj.popEnv()).setProjection(projection));
        return (GChoice)GCompoundInteractionNodeDel.super.leaveProjection(parent, child, proj, gc);
    }
}

