/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.del.local;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.Choice;
import org.scribble.ast.ScribNode;
import org.scribble.ast.local.LChoice;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.del.ChoiceDel;
import org.scribble.del.local.LCompoundInteractionNodeDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.RoleKind;
import org.scribble.sesstype.name.RecVar;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.EndpointGraphBuilder;
import org.scribble.visit.ProjectedChoiceDoPruner;
import org.scribble.visit.ProjectedChoiceSubjectFixer;
import org.scribble.visit.ProtocolDefInliner;
import org.scribble.visit.ReachabilityChecker;
import org.scribble.visit.UnguardedChoiceDoProjectionChecker;
import org.scribble.visit.env.Env;
import org.scribble.visit.env.InlineProtocolEnv;
import org.scribble.visit.env.ReachabilityEnv;
import org.scribble.visit.env.UnguardedChoiceDoEnv;

public class LChoiceDel
extends ChoiceDel
implements LCompoundInteractionNodeDel {
    @Override
    public ScribNode leaveUnguardedChoiceDoProjectionCheck(ScribNode parent, ScribNode child, UnguardedChoiceDoProjectionChecker checker, ScribNode visited) throws ScribbleException {
        Choice cho = (Choice)visited;
        List benvs = cho.getBlocks().stream().map(b -> (UnguardedChoiceDoEnv)b.del().env()).collect(Collectors.toList());
        Env merged = ((UnguardedChoiceDoEnv)checker.popEnv()).mergeContexts(benvs);
        checker.pushEnv(merged);
        return (Choice)super.leaveUnguardedChoiceDoProjectionCheck(parent, child, checker, cho);
    }

    @Override
    public ScribNode leaveProjectedChoiceDoPruning(ScribNode parent, ScribNode child, ProjectedChoiceDoPruner pruner, ScribNode visited) throws ScribbleException {
        LChoice lc = (LChoice)visited;
        List blocks = lc.getBlocks().stream().filter(b -> !b.isEmpty()).collect(Collectors.toList());
        if (blocks.isEmpty()) {
            return null;
        }
        return lc.reconstruct(lc.subj, blocks);
    }

    @Override
    public ScribNode leaveProjectedChoiceSubjectFixing(ScribNode parent, ScribNode child, ProjectedChoiceSubjectFixer fixer, ScribNode visited) throws ScribbleException {
        LChoice lc = (LChoice)visited;
        List<LProtocolBlock> blocks = lc.getBlocks();
        Set subjs = blocks.stream().map(b -> b.getInteractionSeq().getInteractions().get(0).inferLocalChoiceSubject(fixer)).collect(Collectors.toSet());
        if (subjs.size() == 0) {
            throw new RuntimeException("Shouldn't get in here: " + subjs);
        }
        subjs = subjs.stream().map(r -> fixer.isRecVarRole((Role)r) ? fixer.getChoiceSubject(new RecVar(r.toString())) : r).collect(Collectors.toSet());
        if ((subjs = subjs.stream().filter(s -> s != null).collect(Collectors.toSet())).size() > 1) {
            throw new ScribbleException("Cannot project for inconsistent local choice subjects: " + subjs);
        }
        RoleNode subj = (RoleNode)AstFactoryImpl.FACTORY.SimpleNameNode(RoleKind.KIND, ((Role)subjs.iterator().next()).toString());
        fixer.setChoiceSubject(subj.toName());
        LChoice projection = AstFactoryImpl.FACTORY.LChoice(subj, blocks);
        return projection;
    }

    @Override
    public ScribNode leaveProtocolInlining(ScribNode parent, ScribNode child, ProtocolDefInliner inl, ScribNode visited) throws ScribbleException {
        LChoice lc = (LChoice)visited;
        List<LProtocolBlock> blocks = lc.getBlocks().stream().map(b -> (LProtocolBlock)((InlineProtocolEnv)b.del().env()).getTranslation()).collect(Collectors.toList());
        RoleNode subj = lc.subj.clone();
        LChoice inlined = AstFactoryImpl.FACTORY.LChoice(subj, blocks);
        inl.pushEnv(((InlineProtocolEnv)inl.popEnv()).setTranslation(inlined));
        return (LChoice)super.leaveProtocolInlining(parent, child, inl, lc);
    }

    @Override
    public LChoice leaveReachabilityCheck(ScribNode parent, ScribNode child, ReachabilityChecker checker, ScribNode visited) throws ScribbleException {
        LChoice cho = (LChoice)visited;
        List<ReachabilityEnv> benvs = cho.getBlocks().stream().map(b -> (ReachabilityEnv)b.del().env()).collect(Collectors.toList());
        ReachabilityEnv merged = ((ReachabilityEnv)checker.popEnv()).mergeForChoice(benvs);
        checker.pushEnv(merged);
        return (LChoice)LCompoundInteractionNodeDel.super.leaveReachabilityCheck(parent, child, checker, visited);
    }

    public LChoice visitForFsmConversion(EndpointGraphBuilder graph, LChoice child) {
        try {
            graph.builder.enterChoice();
            for (LProtocolBlock block : child.getBlocks()) {
                graph.builder.pushChoiceBlock();
                block.accept(graph);
                graph.builder.popChoiceBlock();
            }
            graph.builder.leaveChoice();
        }
        catch (ScribbleException e) {
            throw new RuntimeException("Shouldn't get in here: " + e);
        }
        return child;
    }
}

