/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.ModelAction;
import org.scribble.model.ModelState;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.RecVar;

public abstract class GraphBuilder<A extends ModelAction<K>, S extends ModelState<A, S, K>, K extends ProtocolKind> {
    private final Map<RecVar, Deque<S>> recvars = new HashMap<RecVar, Deque<S>>();
    private final Map<RecVar, Deque<Set<A>>> enacting = new HashMap<RecVar, Deque<Set<A>>>();
    protected final Map<S, Map<RecVar, Set<A>>> enactingMap = new HashMap<S, Map<RecVar, Set<A>>>();
    private final Deque<List<S>> pred = new LinkedList<List<S>>();
    private final Deque<List<A>> prev = new LinkedList<List<A>>();
    protected S entry;
    protected S exit;

    public GraphBuilder() {
        this.clear();
    }

    protected void clear() {
        this.recvars.clear();
        this.enacting.clear();
        this.pred.clear();
        this.prev.clear();
        this.pred.push(new LinkedList());
        this.prev.push(new LinkedList());
        this.enactingMap.clear();
    }

    public void reset() {
        this.clear();
        this.entry = this.newState(Collections.emptySet());
        this.exit = this.newState(Collections.emptySet());
    }

    public abstract S newState(Set<RecVar> var1);

    public void addEntryLabel(RecVar lab) {
        ((ModelState)this.entry).addLabel(lab);
    }

    protected void addEdgeAux(S s, A a, S succ) {
        ((ModelState)s).addEdge(a, succ);
    }

    public void addEdge(S s, A a, S succ) {
        ((ModelState)s).addEdge(a, succ);
        this.pred.pop();
        this.prev.pop();
        this.pred.push(new LinkedList<ModelState>(Arrays.asList(s)));
        this.prev.push(new LinkedList<ModelAction>(Arrays.asList(a)));
        for (Deque<Set<A>> ens : this.enacting.values()) {
            Set<A> tmp;
            if (ens.isEmpty() || !(tmp = ens.peek()).isEmpty()) continue;
            tmp.add(a);
        }
    }

    protected void addRecursionEdge(S s, A a, S succ) {
        ((ModelState)s).addEdge(a, succ);
        for (Deque<Set<A>> ens : this.enacting.values()) {
            Set<A> tmp;
            if (ens.isEmpty() || !(tmp = ens.peek()).isEmpty()) continue;
            tmp.add(a);
        }
    }

    protected void removeEdgeFromPredecessor(S s, A a) throws ScribbleException {
        ((ModelState)s).removeEdge(a, this.getEntry());
        Iterator<S> preds = this.pred.peek().iterator();
        Iterator<A> prevs = this.prev.peek().iterator();
        while (preds.hasNext()) {
            ModelState nexts = (ModelState)preds.next();
            ModelAction nexta = (ModelAction)prevs.next();
            if (!nexts.equals(s) || !nexta.equals(a)) continue;
            preds.remove();
            prevs.remove();
            return;
        }
        throw new RuntimeException("Shouldn't get in here: " + s + ", " + a);
    }

    public void enterChoice() {
        this.pred.push(new LinkedList());
        this.prev.push(new LinkedList());
        for (RecVar rv : this.enacting.keySet()) {
            Deque<Set<A>> tmp = this.enacting.get(rv);
            tmp.push(new HashSet());
        }
    }

    public void leaveChoice() {
        List<S> pred = this.pred.pop();
        List<A> prev = this.prev.pop();
        if (!pred.isEmpty()) {
            this.pred.pop();
            this.prev.pop();
            this.pred.push(pred);
            this.prev.push(prev);
        }
        for (RecVar rv : this.enacting.keySet()) {
            Set<A> pop = this.enacting.get(rv).pop();
            Set<A> peek = this.enacting.get(rv).peek();
            if (!peek.isEmpty()) continue;
            peek.addAll(pop);
        }
    }

    public void pushChoiceBlock() {
        this.pred.push(null);
        this.prev.push(null);
        for (RecVar rv : this.enacting.keySet()) {
            Deque<Set<A>> tmp = this.enacting.get(rv);
            tmp.push(new HashSet());
        }
    }

    public void popChoiceBlock() {
        List<S> pred = this.pred.pop();
        List<A> prev = this.prev.pop();
        if (pred != null) {
            List<S> peek1 = this.pred.peek();
            if (peek1 == null) {
                this.pred.pop();
                peek1 = new LinkedList<S>();
                this.pred.push(peek1);
            }
            peek1.addAll(pred);
        }
        if (prev != null) {
            List<A> peek2 = this.prev.peek();
            if (peek2 == null) {
                this.prev.pop();
                peek2 = new LinkedList<A>();
                this.prev.push(peek2);
            }
            peek2.addAll(prev);
        }
        for (RecVar rv : this.enacting.keySet()) {
            Set<A> pop = this.enacting.get(rv).pop();
            Set<A> peek = this.enacting.get(rv).peek();
            peek.addAll(pop);
        }
    }

    public boolean isUnguardedInChoice() {
        return this.pred.peek() == null;
    }

    public void pushRecursionEntry(RecVar recvar, S entry) {
        Deque<S> tmp = this.recvars.get(recvar);
        if (tmp == null) {
            tmp = new LinkedList<S>();
            this.recvars.put(recvar, tmp);
        }
        tmp.push(entry);
        Deque<Set<A>> tmp2 = this.enacting.get(recvar);
        if (tmp2 == null) {
            tmp2 = new LinkedList<Set<A>>();
            this.enacting.put(recvar, tmp2);
        }
        tmp2.push(new HashSet());
    }

    public void popRecursionEntry(RecVar recvar) {
        S curr;
        Map<RecVar, Set<A>> tmp;
        this.recvars.get(recvar).pop();
        Set<A> pop = this.enacting.get(recvar).pop();
        if (this.enacting.get(recvar).isEmpty()) {
            this.enacting.remove(recvar);
        }
        if ((tmp = this.enactingMap.get(curr = this.getEntry())) == null) {
            tmp = new HashMap<RecVar, Set<A>>();
            this.enactingMap.put(curr, tmp);
        }
        tmp.put(recvar, pop);
    }

    public List<S> getPredecessors() {
        return new LinkedList(this.pred.peek());
    }

    public List<A> getPreviousActions() {
        return new LinkedList(this.prev.peek());
    }

    public S getRecursionEntry(RecVar recvar) {
        return (S)((ModelState)this.recvars.get(recvar).peek());
    }

    public S getEntry() {
        return this.entry;
    }

    public void setEntry(S entry) {
        this.entry = entry;
    }

    public S getExit() {
        return this.exit;
    }

    public void setExit(S exit) {
        this.exit = exit;
    }
}

