/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.model.ModelAction;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.RecVar;

public abstract class ModelState<A extends ModelAction<K>, S extends ModelState<A, S, K>, K extends ProtocolKind> {
    private static int count = 0;
    public final int id = count++;
    protected final Set<RecVar> labs;
    protected final List<A> actions;
    protected final List<S> succs;

    public ModelState(Set<RecVar> labs) {
        this.labs = new HashSet<RecVar>(labs);
        this.actions = new LinkedList<A>();
        this.succs = new LinkedList<S>();
    }

    protected abstract S newState(Set<RecVar> var1);

    protected void addLabel(RecVar lab) {
        this.labs.add(lab);
    }

    protected void removeEdge(A a, S s) throws ScribbleException {
        Iterator<A> ia = this.actions.iterator();
        Iterator<S> is = this.succs.iterator();
        while (ia.hasNext()) {
            ModelAction tmpa = (ModelAction)ia.next();
            ModelState tmps = (ModelState)is.next();
            if (!tmpa.equals(a) || !tmps.equals(s)) continue;
            ia.remove();
            is.remove();
            return;
        }
        throw new ScribbleException("No such transition to remove: " + a + "->" + s);
    }

    protected void addEdge(A a, S s) {
        Iterator<A> as = this.actions.iterator();
        Iterator<S> ss = this.succs.iterator();
        while (as.hasNext()) {
            ModelAction tmpa = (ModelAction)as.next();
            ModelState tmps = (ModelState)ss.next();
            if (!tmpa.equals(a) || !tmps.equals(s)) continue;
            return;
        }
        this.actions.add(a);
        this.succs.add(s);
    }

    public Set<RecVar> getLabels() {
        return Collections.unmodifiableSet(this.labs);
    }

    public Set<A> getTakeable() {
        HashSet<A> as = new HashSet<A>(this.actions);
        if (as.size() != this.actions.size()) {
            throw new RuntimeScribbleException("[TODO] Non-deterministic state: " + this.actions + "  (Try -minfsm if available)");
        }
        return as;
    }

    public List<A> getAllTakeable() {
        return Collections.unmodifiableList(this.actions);
    }

    public boolean isTakeable(A a) {
        return this.actions.contains(a);
    }

    public S take(A a) {
        HashSet<A> as = new HashSet<A>(this.actions);
        if (as.size() != this.actions.size()) {
            throw new RuntimeException("FIXME: " + this.actions);
        }
        return (S)((ModelState)this.takeAll(a).get(0));
    }

    public List<S> takeAll(A a) {
        return IntStream.range(0, this.actions.size()).filter(i -> ((ModelAction)this.actions.get(i)).equals(a)).mapToObj(i -> (ModelState)this.succs.get(i)).collect(Collectors.toList());
    }

    public List<S> getSuccessors() {
        return Collections.unmodifiableList(this.succs);
    }

    public boolean isTerminal() {
        return this.actions.isEmpty();
    }

    public final int hashCode() {
        int hash = 73;
        hash = 31 * hash + this.id;
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelState)) {
            return false;
        }
        return this.id == ((ModelState)o).id;
    }

    public String toLongString() {
        String s = "\"" + this.id + "\":[";
        Iterator<S> ss = this.succs.iterator();
        s = String.valueOf(s) + this.actions.stream().map(a -> a + "=\"" + ((ModelState)iterator.next()).id + "\"").collect(Collectors.joining(", "));
        return String.valueOf(s) + "]";
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public final String toDot() {
        String s = "digraph G {\ncompound = true;\n";
        s = String.valueOf(s) + this.toDot(new HashSet<ModelState<A, S, K>>());
        return String.valueOf(s) + "\n}";
    }

    protected final String toDot(Set<ModelState<A, S, K>> seen) {
        seen.add(this);
        String dot = this.toNodeDot();
        int i = 0;
        while (i < this.actions.size()) {
            ModelAction a = (ModelAction)this.actions.get(i);
            ModelState s = (ModelState)this.succs.get(i);
            dot = String.valueOf(dot) + "\n" + this.toEdgeDot(a, s);
            if (!seen.contains(s)) {
                dot = String.valueOf(dot) + "\n" + s.toDot(seen);
            }
            ++i;
        }
        return dot;
    }

    protected final String toEdgeDot(String src, String dest, String lab) {
        return String.valueOf(src) + " -> " + dest + " [ " + lab + " ];";
    }

    protected String toNodeDot() {
        return String.valueOf(this.getDotNodeId()) + " [ " + this.getNodeLabel() + " ];";
    }

    protected String getNodeLabel() {
        String labs = this.labs.toString();
        return "label=\"" + this.id + ": " + labs.substring(1, labs.length() - 1) + "\"";
    }

    protected String getDotNodeId() {
        return "\"" + this.id + "\"";
    }

    protected String toEdgeDot(A msg, S next) {
        return this.toEdgeDot(this.getDotNodeId(), ((ModelState)next).getDotNodeId(), ((ModelState)next).getEdgeLabel(msg));
    }

    protected String getEdgeLabel(A msg) {
        return "label=\"" + msg + "\"";
    }

    public static <A extends ModelAction<K>, S extends ModelState<A, S, K>, K extends ProtocolKind> S getTerminal(S start) {
        if (start.isTerminal()) {
            return start;
        }
        Set terms = ModelState.getAllReachable(start).stream().filter(s -> s.isTerminal()).collect(Collectors.toSet());
        if (terms.size() > 1) {
            throw new RuntimeException("Shouldn't get in here: " + terms);
        }
        return (S)(terms.isEmpty() ? null : (ModelState)terms.iterator().next());
    }

    public static <A extends ModelAction<K>, S extends ModelState<A, S, K>, K extends ProtocolKind> Set<S> getAllReachable(ModelState<A, S, K> start) {
        HashMap<Integer, ModelState> all = new HashMap<Integer, ModelState>();
        LinkedHashMap<Integer, ModelState> todo = new LinkedHashMap<Integer, ModelState>();
        todo.put(start.id, start);
        while (!todo.isEmpty()) {
            Iterator i = todo.values().iterator();
            ModelState next = (ModelState)i.next();
            todo.remove(next.id);
            for (ModelState s : next.getSuccessors()) {
                if (all.containsKey(s.id)) continue;
                all.put(s.id, s);
                todo.put(s.id, s);
            }
        }
        return new HashSet(all.values());
    }

    public static <A extends ModelAction<K>, S extends ModelState<A, S, K>, K extends ProtocolKind> Set<A> getAllReachableActions(ModelState<A, S, K> start) {
        HashSet<ModelState<A, S, K>> all = new HashSet<ModelState<A, S, K>>();
        all.add(start);
        all.addAll(ModelState.getAllReachable(start));
        HashSet<A> as = new HashSet<A>();
        for (ModelState modelState : all) {
            as.addAll(modelState.getAllTakeable());
        }
        return as;
    }

    public String toAut() {
        HashSet<ModelState<A, S, K>> all = new HashSet<ModelState<A, S, K>>();
        all.add(this);
        all.addAll(ModelState.getAllReachable(this));
        String aut = "";
        int edges = 0;
        HashSet<Integer> seen = new HashSet<Integer>();
        for (ModelState modelState : all) {
            if (seen.contains(modelState.id)) continue;
            seen.add(modelState.id);
            Iterator<A> as = modelState.getAllTakeable().iterator();
            Iterator<S> ss = modelState.getSuccessors().iterator();
            while (as.hasNext()) {
                ModelAction a = (ModelAction)as.next();
                ModelState succ = (ModelState)ss.next();
                String msg = a.toStringWithMessageIdHack();
                aut = String.valueOf(aut) + "\n(" + modelState.id + ",\"" + msg + "\"," + succ.id + ")";
                ++edges;
            }
        }
        return "des (" + this.id + "," + edges + "," + all.size() + ")" + aut + "\n";
    }

    public S clone() {
        HashSet<ModelState<A, S, K>> all = new HashSet<ModelState<A, S, K>>();
        all.add(this);
        all.addAll(ModelState.getAllReachable(this));
        HashMap<Integer, S> map = new HashMap<Integer, S>();
        for (ModelState modelState : all) {
            map.put(modelState.id, this.newState(modelState.labs));
        }
        for (ModelState modelState : all) {
            Iterator<A> as = modelState.getAllTakeable().iterator();
            Iterator<S> ss = modelState.getSuccessors().iterator();
            ModelState clone = (ModelState)map.get(modelState.id);
            while (as.hasNext()) {
                ModelAction a = (ModelAction)as.next();
                ModelState succ = (ModelState)ss.next();
                clone.addEdge(a, (ModelState)map.get(succ.id));
            }
        }
        return (S)((ModelState)map.get(this.id));
    }

    public boolean canReach(ModelState<A, S, K> s) {
        return ModelState.getAllReachable(this).contains(s);
    }
}

