/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.ModelState;
import org.scribble.model.local.EndpointGraph;
import org.scribble.model.local.IOAction;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.name.RecVar;

public class EndpointState
extends ModelState<IOAction, EndpointState, Local> {
    protected EndpointState(Set<RecVar> labs) {
        super(labs);
    }

    public EndpointGraph toGraph() {
        return new EndpointGraph(this, EndpointState.getTerminal(this));
    }

    public EndpointState unfairTransform() {
        EndpointState init = (EndpointState)this.clone();
        EndpointState term = ModelState.getTerminal(init);
        HashSet<EndpointState> seen = new HashSet<EndpointState>();
        LinkedHashSet<Object> todo = new LinkedHashSet<Object>();
        todo.add(init);
        while (!todo.isEmpty()) {
            Iterator i = todo.iterator();
            EndpointState curr = (EndpointState)i.next();
            i.remove();
            if (seen.contains(curr)) continue;
            seen.add(curr);
            if (curr.getStateKind() == Kind.OUTPUT && curr.getAllTakeable().size() > 1) {
                Iterator as = curr.getAllTakeable().iterator();
                Iterator ss = curr.getSuccessors().iterator();
                LinkedList<IOAction> cloneas = new LinkedList<IOAction>();
                LinkedList<EndpointState> cloness = new LinkedList<EndpointState>();
                HashMap<Object, IOAction> toRemove = new HashMap<Object, IOAction>();
                while (as.hasNext()) {
                    IOAction a = (IOAction)as.next();
                    EndpointState s = (EndpointState)ss.next();
                    if (!s.canReach(curr)) {
                        todo.add(s);
                        continue;
                    }
                    EndpointState clone = curr.unfairClone(term, a, s);
                    cloneas.add(a);
                    cloness.add(clone);
                    toRemove.put(s, a);
                }
                if (cloneas.isEmpty()) continue;
                for (EndpointState s : toRemove.keySet()) {
                    try {
                        curr.removeEdge((IOAction)toRemove.get(s), s);
                    }
                    catch (ScribbleException e) {
                        throw new RuntimeException(e);
                    }
                }
                Iterator icloneas = cloneas.iterator();
                Iterator icloness = cloness.iterator();
                while (icloneas.hasNext()) {
                    IOAction a = (IOAction)icloneas.next();
                    EndpointState s = (EndpointState)icloness.next();
                    curr.addEdge(a, s);
                    todo.add(s);
                }
                continue;
            }
            todo.addAll(curr.getSuccessors());
        }
        return init;
    }

    protected EndpointState unfairClone(EndpointState term, IOAction a, EndpointState succ) {
        HashSet<EndpointState> all = new HashSet<EndpointState>();
        all.add(succ);
        all.addAll(ModelState.getAllReachable(succ));
        HashMap<Integer, ModelState> map = new HashMap<Integer, ModelState>();
        for (EndpointState s : all) {
            if (term != null && s.id == term.id) {
                map.put(term.id, term);
                continue;
            }
            map.put(s.id, this.newState(Collections.emptySet()));
        }
        for (EndpointState s : all) {
            Iterator as = s.getAllTakeable().iterator();
            Iterator ss = s.getSuccessors().iterator();
            EndpointState clone = (EndpointState)map.get(s.id);
            while (as.hasNext()) {
                IOAction tmpa = (IOAction)as.next();
                EndpointState tmps = (EndpointState)ss.next();
                if (s.id == this.id && (!tmpa.equals(a) || !tmps.equals(succ))) continue;
                clone.addEdge(tmpa, (EndpointState)map.get(tmps.id));
            }
        }
        return (EndpointState)map.get(succ.id);
    }

    @Override
    protected EndpointState newState(Set<RecVar> labs) {
        return new EndpointState(labs);
    }

    public boolean isConnectOrWrapClientOnly() {
        return this.getStateKind() == Kind.OUTPUT && this.getAllTakeable().stream().allMatch(a -> a.isConnect() || a.isWrapClient());
    }

    public Kind getStateKind() {
        List as = this.getAllTakeable();
        if (as.size() == 0) {
            return Kind.TERMINAL;
        }
        IOAction a = (IOAction)as.iterator().next();
        return a.isSend() || a.isConnect() || a.isDisconnect() || a.isWrapClient() ? Kind.OUTPUT : (a.isAccept() ? Kind.ACCEPT : (a.isWrapServer() ? Kind.WRAP_SERVER : (as.size() > 1 ? Kind.POLY_INPUT : Kind.UNARY_INPUT)));
    }

    public static enum Kind {
        OUTPUT,
        UNARY_INPUT,
        POLY_INPUT,
        TERMINAL,
        ACCEPT,
        WRAP_SERVER;

    }
}

