/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.scribble.model.local.IOAction;

public class IOTrace {
    private final IOAction[] elements;

    public IOTrace(IOAction ... elements) {
        this.elements = elements;
    }

    protected IOTrace(IOAction[] p1, IOAction ... p2) {
        this(IOTrace.foo(p1, p2));
    }

    private static IOAction[] foo(IOAction[] p1, IOAction[] p2) {
        IOAction[] copy = Arrays.copyOf(p1, p1.length + p2.length);
        System.arraycopy(p2, 0, copy, p1.length, p2.length);
        return copy;
    }

    public boolean containsEdge(IOAction a) {
        return Arrays.stream(this.elements).anyMatch(x -> x.equals(a));
    }

    public IOTrace append(IOAction pe) {
        return new IOTrace(this.elements, new IOAction[]{pe});
    }

    public IOTrace concat(IOTrace p) {
        return new IOTrace(this.elements, p.elements);
    }

    public List<IOAction> getElements() {
        return Collections.unmodifiableList(Arrays.asList(this.elements));
    }

    public IOAction getLastElement() {
        return this.elements[this.elements.length - 1];
    }

    public String toString() {
        return Arrays.toString(this.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IOTrace)) {
            return false;
        }
        return Arrays.equals(((IOTrace)o).elements, this.elements);
    }
}

