/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.scribble.main.ScribbleException;
import org.scribble.model.GraphBuilder;
import org.scribble.model.local.EndpointGraph;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.model.local.IntermediateContinueEdge;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.name.RecVar;

public class LGraphBuilder
extends GraphBuilder<IOAction, EndpointState, Local> {
    @Override
    public void removeEdgeFromPredecessor(EndpointState s, IOAction a) throws ScribbleException {
        super.removeEdgeFromPredecessor(s, a);
    }

    @Override
    public void addRecursionEdge(EndpointState s, IOAction a, EndpointState succ) {
        super.addRecursionEdge(s, a, succ);
    }

    public void addContinueEdge(EndpointState s, RecVar rv) {
        EndpointState entry = (EndpointState)this.getRecursionEntry(rv);
        this.addEdgeAux(s, new IntermediateContinueEdge(rv), entry);
    }

    public EndpointGraph finalise() {
        EndpointState res = new EndpointState(((EndpointState)this.entry).getLabels());
        EndpointState resTerm = new EndpointState(((EndpointState)this.exit).getLabels());
        HashMap<EndpointState, EndpointState> map = new HashMap<EndpointState, EndpointState>();
        map.put((EndpointState)this.entry, res);
        map.put((EndpointState)this.exit, resTerm);
        HashSet<EndpointState> seen = new HashSet<EndpointState>();
        this.fixContinueEdges(seen, map, (EndpointState)this.entry, res);
        if (!seen.contains(this.exit)) {
            resTerm = null;
        }
        return new EndpointGraph(res, resTerm);
    }

    private void fixContinueEdges(Set<EndpointState> seen, Map<EndpointState, EndpointState> map, EndpointState curr, EndpointState res) {
        if (seen.contains(curr)) {
            return;
        }
        seen.add(curr);
        Iterator as = curr.getAllTakeable().iterator();
        Iterator ss = curr.getSuccessors().iterator();
        while (as.hasNext()) {
            IOAction a = (IOAction)as.next();
            EndpointState succ = (EndpointState)ss.next();
            EndpointState next = this.getNext(map, succ);
            if (!(a instanceof IntermediateContinueEdge)) {
                this.addEdgeAux(res, a, next);
                this.fixContinueEdges(seen, map, succ, next);
                continue;
            }
            IntermediateContinueEdge ice = (IntermediateContinueEdge)a;
            RecVar rv = new RecVar(ice.mid.toString());
            for (IOAction e : (Set)((Map)this.enactingMap.get(succ)).get(rv)) {
                for (EndpointState n : succ.takeAll(e)) {
                    next = this.getNext(map, n);
                    this.addEdgeAux(res, e, next);
                    this.fixContinueEdges(seen, map, succ, next);
                }
            }
        }
    }

    private EndpointState getNext(Map<EndpointState, EndpointState> map, EndpointState succ) {
        EndpointState next;
        if (map.containsKey(succ)) {
            next = map.get(succ);
        } else {
            next = new EndpointState(succ.getLabels());
            map.put(succ, next);
        }
        return next;
    }

    @Override
    public EndpointState newState(Set<RecVar> labs) {
        return new EndpointState(labs);
    }
}

