/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.wf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.model.local.Accept;
import org.scribble.model.local.Connect;
import org.scribble.model.local.Disconnect;
import org.scribble.model.local.EndpointState;
import org.scribble.model.local.IOAction;
import org.scribble.model.local.Receive;
import org.scribble.model.local.Send;
import org.scribble.model.local.WrapClient;
import org.scribble.model.local.WrapServer;
import org.scribble.sesstype.name.Role;

public class WFBuffers {
    private final Map<Role, Map<Role, Boolean>> connected = new HashMap<Role, Map<Role, Boolean>>();
    private final Map<Role, Map<Role, Send>> buffs = new HashMap<Role, Map<Role, Send>>();

    public WFBuffers(Set<Role> roles, boolean implicit) {
        this(roles);
        if (implicit) {
            roles.forEach(k -> {
                HashMap tmp = new HashMap();
                this.connected.put((Role)k, tmp);
                roles.forEach(k2 -> {
                    if (!k.equals(k2)) {
                        tmp.put(k2, true);
                    }
                });
            });
        }
    }

    public WFBuffers(Set<Role> roles) {
        roles.forEach(k -> {
            HashMap tmp = new HashMap();
            this.buffs.put((Role)k, tmp);
            roles.forEach(k2 -> {
                if (!k.equals(k2)) {
                    tmp.put(k2, null);
                }
            });
        });
    }

    public WFBuffers(WFBuffers buffs) {
        Set<Role> roles = buffs.buffs.keySet();
        roles.forEach(k -> {
            Map<Role, Boolean> tmp = wFBuffers.connected.get(k);
            if (tmp != null) {
                this.connected.put((Role)k, (Map<Role, Boolean>)new HashMap<Role, Boolean>(tmp));
            }
        });
        roles.forEach(k -> this.buffs.put((Role)k, (Map<Role, Send>)new HashMap<Role, Send>(wFBuffers.buffs.get(k))));
    }

    public Map<Role, Map<Role, Send>> getBuffers() {
        return new WFBuffers((WFBuffers)this).buffs;
    }

    public Map<Role, Send> get(Role r) {
        return Collections.unmodifiableMap(this.buffs.get(r));
    }

    public boolean isEmpty(Role r) {
        return this.buffs.get(r).values().stream().allMatch(v -> v == null);
    }

    public boolean isConnected(Role self, Role peer) {
        Map<Role, Boolean> tmp = this.connected.get(self);
        if (tmp == null) {
            return false;
        }
        Boolean b = tmp.get(peer);
        return b != null && b != false;
    }

    public boolean canAccept(Role self, Accept a) {
        return !this.isConnected(self, a.peer);
    }

    public boolean canConnect(Role self, Connect c) {
        return !this.isConnected(self, c.peer);
    }

    public boolean canDisconnect(Role self, Disconnect d) {
        return this.isConnected(self, d.peer);
    }

    public boolean canWrapClient(Role self, WrapClient wc) {
        return this.isConnected(self, wc.peer);
    }

    public boolean canWrapServer(Role self, WrapServer ws) {
        return this.isConnected(self, ws.peer);
    }

    public WFBuffers connect(Role src, Role dest) {
        WFBuffers copy = new WFBuffers(this);
        Map<Role, Boolean> tmp1 = copy.connected.get(src);
        if (tmp1 == null) {
            tmp1 = new HashMap<Role, Boolean>();
            copy.connected.put(src, tmp1);
        }
        tmp1.put(dest, true);
        Map<Role, Boolean> tmp2 = copy.connected.get(dest);
        if (tmp2 == null) {
            tmp2 = new HashMap<Role, Boolean>();
            copy.connected.put(dest, tmp2);
        }
        tmp2.put(src, true);
        return copy;
    }

    public WFBuffers disconnect(Role self, Disconnect d) {
        WFBuffers copy = new WFBuffers(this);
        copy.connected.get(self).put(d.peer, false);
        return copy;
    }

    public boolean canSend(Role self, Send a) {
        return this.isConnected(self, a.peer) && this.buffs.get(a.peer).get(self) == null;
    }

    public WFBuffers send(Role self, Send a) {
        WFBuffers copy = new WFBuffers(this);
        copy.buffs.get(a.peer).put(self, a);
        return copy;
    }

    public Set<IOAction> inputable(Role r) {
        Set<IOAction> res = this.buffs.get(r).entrySet().stream().filter(e -> e.getValue() != null).map(e -> ((Send)e.getValue()).toDual((Role)e.getKey())).collect(Collectors.toSet());
        return res;
    }

    public Set<IOAction> acceptable(Role r, EndpointState curr) {
        Boolean b;
        HashSet<IOAction> res = new HashSet<IOAction>();
        Map<Role, Boolean> tmp = this.connected.get(r);
        if (tmp != null && (b = tmp.get(r)) != null && b.booleanValue()) {
            return res;
        }
        List as = curr.getAllTakeable();
        for (IOAction a : as) {
            res.add((Accept)a);
        }
        return res;
    }

    public Set<IOAction> wrapable(Role r) {
        HashSet<IOAction> res = new HashSet<IOAction>();
        Map<Role, Boolean> tmp = this.connected.get(r);
        if (tmp != null) {
            this.connected.keySet().stream().filter(k -> tmp.containsKey(k) && (Boolean)tmp.get(k) != false).forEach(k -> {
                boolean bl = res.add(new WrapServer((Role)k));
            });
        }
        return res;
    }

    public WFBuffers receive(Role self, Receive a) {
        WFBuffers copy = new WFBuffers(this);
        copy.buffs.get(self).put(a.peer, null);
        return copy;
    }

    public final int hashCode() {
        int hash = 131;
        hash = 31 * hash + this.buffs.hashCode();
        hash = 31 * hash + this.connected.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WFBuffers)) {
            return false;
        }
        WFBuffers b = (WFBuffers)o;
        return this.buffs.equals(b.buffs) && this.connected.equals(b.connected);
    }

    public String toString() {
        return this.buffs.entrySet().stream().filter(e -> ((Map)e.getValue()).values().stream().anyMatch(v -> v != null)).collect(Collectors.toMap(e -> (Role)e.getKey(), e -> ((Map)e.getValue()).entrySet().stream().filter(f -> f.getValue() != null).collect(Collectors.toMap(f -> (Role)f.getKey(), f -> f.getValue())))).toString();
    }
}

